package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBatchInferenceJobsResponse(
    batchInferenceJobs: Optional[
      Iterable[zio.aws.personalize.model.BatchInferenceJobSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse = {
    import ListBatchInferenceJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse
      .builder()
      .optionallyWith(
        batchInferenceJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.batchInferenceJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly =
    zio.aws.personalize.model.ListBatchInferenceJobsResponse
      .wrap(buildAwsValue())
}
object ListBatchInferenceJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListBatchInferenceJobsResponse =
      zio.aws.personalize.model.ListBatchInferenceJobsResponse(
        batchInferenceJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def batchInferenceJobs: Optional[
      List[zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getBatchInferenceJobs: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("batchInferenceJobs", batchInferenceJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse
  ) extends zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly {
    override val batchInferenceJobs: Optional[
      List[zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.batchInferenceJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.BatchInferenceJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse
  ): zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly =
    new Wrapper(impl)
}
