package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMetricAttributionMetricsResponse(
    metrics: Optional[Iterable[zio.aws.personalize.model.MetricAttribute]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse = {
    import ListMetricAttributionMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse
      .builder()
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListMetricAttributionMetricsResponse.ReadOnly =
    zio.aws.personalize.model.ListMetricAttributionMetricsResponse
      .wrap(buildAwsValue())
}
object ListMetricAttributionMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.ListMetricAttributionMetricsResponse =
      zio.aws.personalize.model.ListMetricAttributionMetricsResponse(
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metrics
        : Optional[List[zio.aws.personalize.model.MetricAttribute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.MetricAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse
  ) extends zio.aws.personalize.model.ListMetricAttributionMetricsResponse.ReadOnly {
    override val metrics
        : Optional[List[zio.aws.personalize.model.MetricAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.MetricAttribute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse
  ): zio.aws.personalize.model.ListMetricAttributionMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
