package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMetricAttributionsResponse(
    metricAttributions: Optional[
      Iterable[zio.aws.personalize.model.MetricAttributionSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse = {
    import ListMetricAttributionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse
      .builder()
      .optionallyWith(
        metricAttributions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricAttributions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListMetricAttributionsResponse.ReadOnly =
    zio.aws.personalize.model.ListMetricAttributionsResponse
      .wrap(buildAwsValue())
}
object ListMetricAttributionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListMetricAttributionsResponse =
      zio.aws.personalize.model.ListMetricAttributionsResponse(
        metricAttributions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metricAttributions: Optional[
      List[zio.aws.personalize.model.MetricAttributionSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getMetricAttributions: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.MetricAttributionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("metricAttributions", metricAttributions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse
  ) extends zio.aws.personalize.model.ListMetricAttributionsResponse.ReadOnly {
    override val metricAttributions: Optional[
      List[zio.aws.personalize.model.MetricAttributionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricAttributions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.MetricAttributionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse
  ): zio.aws.personalize.model.ListMetricAttributionsResponse.ReadOnly =
    new Wrapper(impl)
}
