package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRecipesResponse(
    recipes: Optional[Iterable[zio.aws.personalize.model.RecipeSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListRecipesResponse = {
    import ListRecipesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListRecipesResponse
      .builder()
      .optionallyWith(
        recipes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recipes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListRecipesResponse.ReadOnly =
    zio.aws.personalize.model.ListRecipesResponse.wrap(buildAwsValue())
}
object ListRecipesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListRecipesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListRecipesResponse =
      zio.aws.personalize.model.ListRecipesResponse(
        recipes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recipes
        : Optional[List[zio.aws.personalize.model.RecipeSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRecipes: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.RecipeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("recipes", recipes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListRecipesResponse
  ) extends zio.aws.personalize.model.ListRecipesResponse.ReadOnly {
    override val recipes
        : Optional[List[zio.aws.personalize.model.RecipeSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.RecipeSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListRecipesResponse
  ): zio.aws.personalize.model.ListRecipesResponse.ReadOnly = new Wrapper(impl)
}
