package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRecommendersResponse(
    recommenders: Optional[
      Iterable[zio.aws.personalize.model.RecommenderSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListRecommendersResponse = {
    import ListRecommendersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
      .builder()
      .optionallyWith(
        recommenders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommenders)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListRecommendersResponse.ReadOnly =
    zio.aws.personalize.model.ListRecommendersResponse.wrap(buildAwsValue())
}
object ListRecommendersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListRecommendersResponse =
      zio.aws.personalize.model.ListRecommendersResponse(
        recommenders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommenders
        : Optional[List[zio.aws.personalize.model.RecommenderSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRecommenders: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.RecommenderSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("recommenders", recommenders)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
  ) extends zio.aws.personalize.model.ListRecommendersResponse.ReadOnly {
    override val recommenders: Optional[
      List[zio.aws.personalize.model.RecommenderSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.RecommenderSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListRecommendersResponse
  ): zio.aws.personalize.model.ListRecommendersResponse.ReadOnly = new Wrapper(
    impl
  )
}
