package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSolutionsResponse(
    solutions: Optional[Iterable[zio.aws.personalize.model.SolutionSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListSolutionsResponse = {
    import ListSolutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListSolutionsResponse
      .builder()
      .optionallyWith(
        solutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.solutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListSolutionsResponse.ReadOnly =
    zio.aws.personalize.model.ListSolutionsResponse.wrap(buildAwsValue())
}
object ListSolutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListSolutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListSolutionsResponse =
      zio.aws.personalize.model.ListSolutionsResponse(
        solutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def solutions
        : Optional[List[zio.aws.personalize.model.SolutionSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSolutions: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.SolutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("solutions", solutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListSolutionsResponse
  ) extends zio.aws.personalize.model.ListSolutionsResponse.ReadOnly {
    override val solutions
        : Optional[List[zio.aws.personalize.model.SolutionSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.SolutionSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListSolutionsResponse
  ): zio.aws.personalize.model.ListSolutionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
