package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.{
  MetricExpression,
  MetricName,
  EventType
}
import scala.jdk.CollectionConverters.*
final case class MetricAttribute(
    eventType: EventType,
    metricName: MetricName,
    expression: MetricExpression
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.MetricAttribute = {
    import MetricAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.MetricAttribute
      .builder()
      .eventType(EventType.unwrap(eventType): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .expression(MetricExpression.unwrap(expression): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.MetricAttribute.ReadOnly =
    zio.aws.personalize.model.MetricAttribute.wrap(buildAwsValue())
}
object MetricAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.MetricAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.MetricAttribute =
      zio.aws.personalize.model
        .MetricAttribute(eventType, metricName, expression)
    def eventType: EventType
    def metricName: MetricName
    def expression: MetricExpression
    def getEventType: ZIO[Any, Nothing, EventType] = ZIO.succeed(eventType)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getExpression: ZIO[Any, Nothing, MetricExpression] =
      ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.MetricAttribute
  ) extends zio.aws.personalize.model.MetricAttribute.ReadOnly {
    override val eventType: EventType =
      zio.aws.personalize.model.primitives.EventType(impl.eventType())
    override val metricName: MetricName =
      zio.aws.personalize.model.primitives.MetricName(impl.metricName())
    override val expression: MetricExpression =
      zio.aws.personalize.model.primitives.MetricExpression(impl.expression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.MetricAttribute
  ): zio.aws.personalize.model.MetricAttribute.ReadOnly = new Wrapper(impl)
}
