package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MetricAttribution(
    name: Optional[Name] = Optional.Absent,
    metricAttributionArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    metricsOutputConfig: Optional[
      zio.aws.personalize.model.MetricAttributionOutput
    ] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.MetricAttribution = {
    import MetricAttribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.MetricAttribution
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        metricAttributionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.metricAttributionArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(metricsOutputConfig.map(value => value.buildAwsValue()))(
        _.metricsOutputConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.MetricAttribution.ReadOnly =
    zio.aws.personalize.model.MetricAttribution.wrap(buildAwsValue())
}
object MetricAttribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.MetricAttribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.MetricAttribution =
      zio.aws.personalize.model.MetricAttribution(
        name.map(value => value),
        metricAttributionArn.map(value => value),
        datasetGroupArn.map(value => value),
        metricsOutputConfig.map(value => value.asEditable),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value)
      )
    def name: Optional[Name]
    def metricAttributionArn: Optional[Arn]
    def datasetGroupArn: Optional[Arn]
    def metricsOutputConfig
        : Optional[zio.aws.personalize.model.MetricAttributionOutput.ReadOnly]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def failureReason: Optional[FailureReason]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getMetricAttributionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("metricAttributionArn", metricAttributionArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getMetricsOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.MetricAttributionOutput.ReadOnly
    ] = AwsError.unwrapOptionField("metricsOutputConfig", metricsOutputConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.MetricAttribution
  ) extends zio.aws.personalize.model.MetricAttribution.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val metricAttributionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricAttributionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val metricsOutputConfig
        : Optional[zio.aws.personalize.model.MetricAttributionOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsOutputConfig())
        .map(value =>
          zio.aws.personalize.model.MetricAttributionOutput.wrap(value)
        )
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.MetricAttribution
  ): zio.aws.personalize.model.MetricAttribution.ReadOnly = new Wrapper(impl)
}
