package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.RoleArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetricAttributionOutput(
    s3DataDestination: Optional[zio.aws.personalize.model.S3DataConfig] =
      Optional.Absent,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.MetricAttributionOutput = {
    import MetricAttributionOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.MetricAttributionOutput
      .builder()
      .optionallyWith(s3DataDestination.map(value => value.buildAwsValue()))(
        _.s3DataDestination
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.MetricAttributionOutput.ReadOnly =
    zio.aws.personalize.model.MetricAttributionOutput.wrap(buildAwsValue())
}
object MetricAttributionOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.MetricAttributionOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.MetricAttributionOutput =
      zio.aws.personalize.model.MetricAttributionOutput(
        s3DataDestination.map(value => value.asEditable),
        roleArn
      )
    def s3DataDestination
        : Optional[zio.aws.personalize.model.S3DataConfig.ReadOnly]
    def roleArn: RoleArn
    def getS3DataDestination
        : ZIO[Any, AwsError, zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      AwsError.unwrapOptionField("s3DataDestination", s3DataDestination)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.MetricAttributionOutput
  ) extends zio.aws.personalize.model.MetricAttributionOutput.ReadOnly {
    override val s3DataDestination
        : Optional[zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DataDestination())
        .map(value => zio.aws.personalize.model.S3DataConfig.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.MetricAttributionOutput
  ): zio.aws.personalize.model.MetricAttributionOutput.ReadOnly = new Wrapper(
    impl
  )
}
