package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  RecipeType,
  Arn,
  Description,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Recipe(
    name: Optional[Name] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    algorithmArn: Optional[Arn] = Optional.Absent,
    featureTransformationArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    recipeType: Optional[RecipeType] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Recipe = {
    import Recipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Recipe
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(
        featureTransformationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.featureTransformationArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        recipeType.map(value => RecipeType.unwrap(value): java.lang.String)
      )(_.recipeType)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Recipe.ReadOnly =
    zio.aws.personalize.model.Recipe.wrap(buildAwsValue())
}
object Recipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Recipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Recipe =
      zio.aws.personalize.model.Recipe(
        name.map(value => value),
        recipeArn.map(value => value),
        algorithmArn.map(value => value),
        featureTransformationArn.map(value => value),
        status.map(value => value),
        description.map(value => value),
        creationDateTime.map(value => value),
        recipeType.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Optional[Name]
    def recipeArn: Optional[Arn]
    def algorithmArn: Optional[Arn]
    def featureTransformationArn: Optional[Arn]
    def status: Optional[Status]
    def description: Optional[Description]
    def creationDateTime: Optional[Date]
    def recipeType: Optional[RecipeType]
    def lastUpdatedDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getFeatureTransformationArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("featureTransformationArn", featureTransformationArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getRecipeType: ZIO[Any, AwsError, RecipeType] =
      AwsError.unwrapOptionField("recipeType", recipeType)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Recipe
  ) extends zio.aws.personalize.model.Recipe.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val algorithmArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val featureTransformationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.featureTransformationArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.personalize.model.primitives.Description(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val recipeType: Optional[RecipeType] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeType())
      .map(value => zio.aws.personalize.model.primitives.RecipeType(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Recipe
  ): zio.aws.personalize.model.Recipe.ReadOnly = new Wrapper(impl)
}
