package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  MetricName,
  Date,
  FailureReason,
  Arn,
  MetricValue,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Recommender(
    recommenderArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    recommenderConfig: Optional[zio.aws.personalize.model.RecommenderConfig] =
      Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    latestRecommenderUpdate: Optional[
      zio.aws.personalize.model.RecommenderUpdateSummary
    ] = Optional.Absent,
    modelMetrics: Optional[Map[MetricName, MetricValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Recommender = {
    import Recommender.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Recommender
      .builder()
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        latestRecommenderUpdate.map(value => value.buildAwsValue())
      )(_.latestRecommenderUpdate)
      .optionallyWith(
        modelMetrics.map(value =>
          value
            .map({ case (key, value) =>
              (MetricName.unwrap(key): java.lang.String) -> (MetricValue
                .unwrap(value): java.lang.Double)
            })
            .asJava
        )
      )(_.modelMetrics)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Recommender.ReadOnly =
    zio.aws.personalize.model.Recommender.wrap(buildAwsValue())
}
object Recommender {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Recommender
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Recommender =
      zio.aws.personalize.model.Recommender(
        recommenderArn.map(value => value),
        datasetGroupArn.map(value => value),
        name.map(value => value),
        recipeArn.map(value => value),
        recommenderConfig.map(value => value.asEditable),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        status.map(value => value),
        failureReason.map(value => value),
        latestRecommenderUpdate.map(value => value.asEditable),
        modelMetrics.map(value => value)
      )
    def recommenderArn: Optional[Arn]
    def datasetGroupArn: Optional[Arn]
    def name: Optional[Name]
    def recipeArn: Optional[Arn]
    def recommenderConfig
        : Optional[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def status: Optional[Status]
    def failureReason: Optional[FailureReason]
    def latestRecommenderUpdate
        : Optional[zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly]
    def modelMetrics: Optional[Map[MetricName, MetricValue]]
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getLatestRecommenderUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "latestRecommenderUpdate",
      latestRecommenderUpdate
    )
    def getModelMetrics: ZIO[Any, AwsError, Map[MetricName, MetricValue]] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Recommender
  ) extends zio.aws.personalize.model.Recommender.ReadOnly {
    override val recommenderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val recommenderConfig
        : Optional[zio.aws.personalize.model.RecommenderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommenderConfig())
        .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val latestRecommenderUpdate: Optional[
      zio.aws.personalize.model.RecommenderUpdateSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRecommenderUpdate())
      .map(value =>
        zio.aws.personalize.model.RecommenderUpdateSummary.wrap(value)
      )
    override val modelMetrics: Optional[Map[MetricName, MetricValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelMetrics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalize.model.primitives.MetricName(
                key
              ) -> zio.aws.personalize.model.primitives.MetricValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Recommender
  ): zio.aws.personalize.model.Recommender.ReadOnly = new Wrapper(impl)
}
