package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  TransactionsPerSecond,
  ParameterValue,
  ParameterName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RecommenderConfig(
    itemExplorationConfig: Optional[Map[ParameterName, ParameterValue]] =
      Optional.Absent,
    minRecommendationRequestsPerSecond: Optional[TransactionsPerSecond] =
      Optional.Absent,
    trainingDataConfig: Optional[zio.aws.personalize.model.TrainingDataConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.RecommenderConfig = {
    import RecommenderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.RecommenderConfig
      .builder()
      .optionallyWith(
        itemExplorationConfig.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.itemExplorationConfig)
      .optionallyWith(
        minRecommendationRequestsPerSecond.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minRecommendationRequestsPerSecond)
      .optionallyWith(trainingDataConfig.map(value => value.buildAwsValue()))(
        _.trainingDataConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.RecommenderConfig.ReadOnly =
    zio.aws.personalize.model.RecommenderConfig.wrap(buildAwsValue())
}
object RecommenderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.RecommenderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.RecommenderConfig =
      zio.aws.personalize.model.RecommenderConfig(
        itemExplorationConfig.map(value => value),
        minRecommendationRequestsPerSecond.map(value => value),
        trainingDataConfig.map(value => value.asEditable)
      )
    def itemExplorationConfig: Optional[Map[ParameterName, ParameterValue]]
    def minRecommendationRequestsPerSecond: Optional[TransactionsPerSecond]
    def trainingDataConfig
        : Optional[zio.aws.personalize.model.TrainingDataConfig.ReadOnly]
    def getItemExplorationConfig
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("itemExplorationConfig", itemExplorationConfig)
    def getMinRecommendationRequestsPerSecond
        : ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField(
        "minRecommendationRequestsPerSecond",
        minRecommendationRequestsPerSecond
      )
    def getTrainingDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.TrainingDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("trainingDataConfig", trainingDataConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderConfig
  ) extends zio.aws.personalize.model.RecommenderConfig.ReadOnly {
    override val itemExplorationConfig
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.itemExplorationConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val minRecommendationRequestsPerSecond
        : Optional[TransactionsPerSecond] = zio.aws.core.internal
      .optionalFromNullable(impl.minRecommendationRequestsPerSecond())
      .map(value =>
        zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
      )
    override val trainingDataConfig
        : Optional[zio.aws.personalize.model.TrainingDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataConfig())
        .map(value => zio.aws.personalize.model.TrainingDataConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderConfig
  ): zio.aws.personalize.model.RecommenderConfig.ReadOnly = new Wrapper(impl)
}
