package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SolutionSummary(
    name: Optional[Name] = Optional.Absent,
    solutionArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.SolutionSummary = {
    import SolutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.SolutionSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.SolutionSummary.ReadOnly =
    zio.aws.personalize.model.SolutionSummary.wrap(buildAwsValue())
}
object SolutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.SolutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.SolutionSummary =
      zio.aws.personalize.model.SolutionSummary(
        name.map(value => value),
        solutionArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        recipeArn.map(value => value)
      )
    def name: Optional[Name]
    def solutionArn: Optional[Arn]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def recipeArn: Optional[Arn]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.SolutionSummary
  ) extends zio.aws.personalize.model.SolutionSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val solutionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.SolutionSummary
  ): zio.aws.personalize.model.SolutionSummary.ReadOnly = new Wrapper(impl)
}
