package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  PerformAutoML,
  Status,
  Date,
  FailureReason,
  Arn,
  EventType,
  PerformHPO,
  Name,
  TrainingHours
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SolutionVersion(
    name: Optional[Name] = Optional.Absent,
    solutionVersionArn: Optional[Arn] = Optional.Absent,
    solutionArn: Optional[Arn] = Optional.Absent,
    performHPO: Optional[PerformHPO] = Optional.Absent,
    performAutoML: Optional[PerformAutoML] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    eventType: Optional[EventType] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    solutionConfig: Optional[zio.aws.personalize.model.SolutionConfig] =
      Optional.Absent,
    trainingHours: Optional[TrainingHours] = Optional.Absent,
    trainingMode: Optional[zio.aws.personalize.model.TrainingMode] =
      Optional.Absent,
    tunedHPOParams: Optional[zio.aws.personalize.model.TunedHPOParams] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.SolutionVersion = {
    import SolutionVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.SolutionVersion
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        performHPO.map(value => PerformHPO.unwrap(value): java.lang.Boolean)
      )(_.performHPO)
      .optionallyWith(
        performAutoML.map(value =>
          PerformAutoML.unwrap(value): java.lang.Boolean
        )
      )(_.performAutoML)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        eventType.map(value => EventType.unwrap(value): java.lang.String)
      )(_.eventType)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(solutionConfig.map(value => value.buildAwsValue()))(
        _.solutionConfig
      )
      .optionallyWith(
        trainingHours.map(value =>
          TrainingHours.unwrap(value): java.lang.Double
        )
      )(_.trainingHours)
      .optionallyWith(trainingMode.map(value => value.unwrap))(_.trainingMode)
      .optionallyWith(tunedHPOParams.map(value => value.buildAwsValue()))(
        _.tunedHPOParams
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.SolutionVersion.ReadOnly =
    zio.aws.personalize.model.SolutionVersion.wrap(buildAwsValue())
}
object SolutionVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.SolutionVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.SolutionVersion =
      zio.aws.personalize.model.SolutionVersion(
        name.map(value => value),
        solutionVersionArn.map(value => value),
        solutionArn.map(value => value),
        performHPO.map(value => value),
        performAutoML.map(value => value),
        recipeArn.map(value => value),
        eventType.map(value => value),
        datasetGroupArn.map(value => value),
        solutionConfig.map(value => value.asEditable),
        trainingHours.map(value => value),
        trainingMode.map(value => value),
        tunedHPOParams.map(value => value.asEditable),
        status.map(value => value),
        failureReason.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Optional[Name]
    def solutionVersionArn: Optional[Arn]
    def solutionArn: Optional[Arn]
    def performHPO: Optional[PerformHPO]
    def performAutoML: Optional[PerformAutoML]
    def recipeArn: Optional[Arn]
    def eventType: Optional[EventType]
    def datasetGroupArn: Optional[Arn]
    def solutionConfig
        : Optional[zio.aws.personalize.model.SolutionConfig.ReadOnly]
    def trainingHours: Optional[TrainingHours]
    def trainingMode: Optional[zio.aws.personalize.model.TrainingMode]
    def tunedHPOParams
        : Optional[zio.aws.personalize.model.TunedHPOParams.ReadOnly]
    def status: Optional[Status]
    def failureReason: Optional[FailureReason]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getPerformHPO: ZIO[Any, AwsError, PerformHPO] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getPerformAutoML: ZIO[Any, AwsError, PerformAutoML] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getEventType: ZIO[Any, AwsError, EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getSolutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("solutionConfig", solutionConfig)
    def getTrainingHours: ZIO[Any, AwsError, TrainingHours] =
      AwsError.unwrapOptionField("trainingHours", trainingHours)
    def getTrainingMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.TrainingMode] =
      AwsError.unwrapOptionField("trainingMode", trainingMode)
    def getTunedHPOParams: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.TunedHPOParams.ReadOnly
    ] = AwsError.unwrapOptionField("tunedHPOParams", tunedHPOParams)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.SolutionVersion
  ) extends zio.aws.personalize.model.SolutionVersion.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val solutionVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val solutionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val performHPO: Optional[PerformHPO] = zio.aws.core.internal
      .optionalFromNullable(impl.performHPO())
      .map(value => zio.aws.personalize.model.primitives.PerformHPO(value))
    override val performAutoML: Optional[PerformAutoML] = zio.aws.core.internal
      .optionalFromNullable(impl.performAutoML())
      .map(value => zio.aws.personalize.model.primitives.PerformAutoML(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val eventType: Optional[EventType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventType())
      .map(value => zio.aws.personalize.model.primitives.EventType(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val solutionConfig
        : Optional[zio.aws.personalize.model.SolutionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionConfig())
        .map(value => zio.aws.personalize.model.SolutionConfig.wrap(value))
    override val trainingHours: Optional[TrainingHours] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingHours())
      .map(value => zio.aws.personalize.model.primitives.TrainingHours(value))
    override val trainingMode
        : Optional[zio.aws.personalize.model.TrainingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingMode())
        .map(value => zio.aws.personalize.model.TrainingMode.wrap(value))
    override val tunedHPOParams
        : Optional[zio.aws.personalize.model.TunedHPOParams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tunedHPOParams())
        .map(value => zio.aws.personalize.model.TunedHPOParams.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.SolutionVersion
  ): zio.aws.personalize.model.SolutionVersion.ReadOnly = new Wrapper(impl)
}
