package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopRecommenderResponse(
    recommenderArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.StopRecommenderResponse = {
    import StopRecommenderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.StopRecommenderResponse
      .builder()
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.StopRecommenderResponse.ReadOnly =
    zio.aws.personalize.model.StopRecommenderResponse.wrap(buildAwsValue())
}
object StopRecommenderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.StopRecommenderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.StopRecommenderResponse =
      zio.aws.personalize.model
        .StopRecommenderResponse(recommenderArn.map(value => value))
    def recommenderArn: Optional[Arn]
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.StopRecommenderResponse
  ) extends zio.aws.personalize.model.StopRecommenderResponse.ReadOnly {
    override val recommenderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.StopRecommenderResponse
  ): zio.aws.personalize.model.StopRecommenderResponse.ReadOnly = new Wrapper(
    impl
  )
}
