package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{ColumnName, DatasetType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TrainingDataConfig(
    excludedDatasetColumns: Optional[Map[DatasetType, Iterable[ColumnName]]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.TrainingDataConfig = {
    import TrainingDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.TrainingDataConfig
      .builder()
      .optionallyWith(
        excludedDatasetColumns.map(value =>
          value
            .map({ case (key, value) =>
              (DatasetType.unwrap(key): java.lang.String) -> value.map { item =>
                ColumnName.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.excludedDatasetColumns)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.TrainingDataConfig.ReadOnly =
    zio.aws.personalize.model.TrainingDataConfig.wrap(buildAwsValue())
}
object TrainingDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.TrainingDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.TrainingDataConfig =
      zio.aws.personalize.model
        .TrainingDataConfig(excludedDatasetColumns.map(value => value))
    def excludedDatasetColumns: Optional[Map[DatasetType, List[ColumnName]]]
    def getExcludedDatasetColumns
        : ZIO[Any, AwsError, Map[DatasetType, List[ColumnName]]] = AwsError
      .unwrapOptionField("excludedDatasetColumns", excludedDatasetColumns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.TrainingDataConfig
  ) extends zio.aws.personalize.model.TrainingDataConfig.ReadOnly {
    override val excludedDatasetColumns
        : Optional[Map[DatasetType, List[ColumnName]]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludedDatasetColumns())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives
              .DatasetType(key) -> value.asScala.map { item =>
              zio.aws.personalize.model.primitives.ColumnName(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.TrainingDataConfig
  ): zio.aws.personalize.model.TrainingDataConfig.ReadOnly = new Wrapper(impl)
}
