package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{TransactionsPerSecond, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateCampaignRequest(
    campaignArn: Arn,
    solutionVersionArn: Optional[Arn] = Optional.Absent,
    minProvisionedTPS: Optional[TransactionsPerSecond] = Optional.Absent,
    campaignConfig: Optional[zio.aws.personalize.model.CampaignConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest = {
    import UpdateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
      .builder()
      .campaignArn(Arn.unwrap(campaignArn): java.lang.String)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        minProvisionedTPS.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minProvisionedTPS)
      .optionallyWith(campaignConfig.map(value => value.buildAwsValue()))(
        _.campaignConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateCampaignRequest.ReadOnly =
    zio.aws.personalize.model.UpdateCampaignRequest.wrap(buildAwsValue())
}
object UpdateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateCampaignRequest =
      zio.aws.personalize.model.UpdateCampaignRequest(
        campaignArn,
        solutionVersionArn.map(value => value),
        minProvisionedTPS.map(value => value),
        campaignConfig.map(value => value.asEditable)
      )
    def campaignArn: Arn
    def solutionVersionArn: Optional[Arn]
    def minProvisionedTPS: Optional[TransactionsPerSecond]
    def campaignConfig
        : Optional[zio.aws.personalize.model.CampaignConfig.ReadOnly]
    def getCampaignArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(campaignArn)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getMinProvisionedTPS: ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField("minProvisionedTPS", minProvisionedTPS)
    def getCampaignConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignConfig.ReadOnly
    ] = AwsError.unwrapOptionField("campaignConfig", campaignConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
  ) extends zio.aws.personalize.model.UpdateCampaignRequest.ReadOnly {
    override val campaignArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.campaignArn())
    override val solutionVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val minProvisionedTPS: Optional[TransactionsPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minProvisionedTPS())
        .map(value =>
          zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
        )
    override val campaignConfig
        : Optional[zio.aws.personalize.model.CampaignConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaignConfig())
        .map(value => zio.aws.personalize.model.CampaignConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest
  ): zio.aws.personalize.model.UpdateCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
