package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetRequest(datasetArn: Arn, schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateDatasetRequest = {
    import UpdateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateDatasetRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateDatasetRequest.ReadOnly =
    zio.aws.personalize.model.UpdateDatasetRequest.wrap(buildAwsValue())
}
object UpdateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateDatasetRequest =
      zio.aws.personalize.model.UpdateDatasetRequest(datasetArn, schemaArn)
    def datasetArn: Arn
    def schemaArn: Arn
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateDatasetRequest
  ) extends zio.aws.personalize.model.UpdateDatasetRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetArn())
    override val schemaArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateDatasetRequest
  ): zio.aws.personalize.model.UpdateDatasetRequest.ReadOnly = new Wrapper(impl)
}
