package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetResponse(
    datasetArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateDatasetResponse = {
    import UpdateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateDatasetResponse
      .builder()
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateDatasetResponse.ReadOnly =
    zio.aws.personalize.model.UpdateDatasetResponse.wrap(buildAwsValue())
}
object UpdateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateDatasetResponse =
      zio.aws.personalize.model
        .UpdateDatasetResponse(datasetArn.map(value => value))
    def datasetArn: Optional[Arn]
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateDatasetResponse
  ) extends zio.aws.personalize.model.UpdateDatasetResponse.ReadOnly {
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateDatasetResponse
  ): zio.aws.personalize.model.UpdateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
