package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Arn, MetricName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateMetricAttributionRequest(
    addMetrics: Optional[Iterable[zio.aws.personalize.model.MetricAttribute]] =
      Optional.Absent,
    removeMetrics: Optional[Iterable[MetricName]] = Optional.Absent,
    metricsOutputConfig: Optional[
      zio.aws.personalize.model.MetricAttributionOutput
    ] = Optional.Absent,
    metricAttributionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest = {
    import UpdateMetricAttributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest
      .builder()
      .optionallyWith(
        addMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addMetrics)
      .optionallyWith(
        removeMetrics.map(value =>
          value.map { item =>
            MetricName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeMetrics)
      .optionallyWith(metricsOutputConfig.map(value => value.buildAwsValue()))(
        _.metricsOutputConfig
      )
      .optionallyWith(
        metricAttributionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.metricAttributionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.UpdateMetricAttributionRequest.ReadOnly =
    zio.aws.personalize.model.UpdateMetricAttributionRequest
      .wrap(buildAwsValue())
}
object UpdateMetricAttributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateMetricAttributionRequest =
      zio.aws.personalize.model.UpdateMetricAttributionRequest(
        addMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeMetrics.map(value => value),
        metricsOutputConfig.map(value => value.asEditable),
        metricAttributionArn.map(value => value)
      )
    def addMetrics
        : Optional[List[zio.aws.personalize.model.MetricAttribute.ReadOnly]]
    def removeMetrics: Optional[List[MetricName]]
    def metricsOutputConfig
        : Optional[zio.aws.personalize.model.MetricAttributionOutput.ReadOnly]
    def metricAttributionArn: Optional[Arn]
    def getAddMetrics: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.MetricAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("addMetrics", addMetrics)
    def getRemoveMetrics: ZIO[Any, AwsError, List[MetricName]] =
      AwsError.unwrapOptionField("removeMetrics", removeMetrics)
    def getMetricsOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.MetricAttributionOutput.ReadOnly
    ] = AwsError.unwrapOptionField("metricsOutputConfig", metricsOutputConfig)
    def getMetricAttributionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("metricAttributionArn", metricAttributionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest
  ) extends zio.aws.personalize.model.UpdateMetricAttributionRequest.ReadOnly {
    override val addMetrics
        : Optional[List[zio.aws.personalize.model.MetricAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.MetricAttribute.wrap(item)
          }.toList
        )
    override val removeMetrics: Optional[List[MetricName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.primitives.MetricName(item)
          }.toList
        )
    override val metricsOutputConfig
        : Optional[zio.aws.personalize.model.MetricAttributionOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsOutputConfig())
        .map(value =>
          zio.aws.personalize.model.MetricAttributionOutput.wrap(value)
        )
    override val metricAttributionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricAttributionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest
  ): zio.aws.personalize.model.UpdateMetricAttributionRequest.ReadOnly =
    new Wrapper(impl)
}
