package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateMetricAttributionResponse(
    metricAttributionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse = {
    import UpdateMetricAttributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse
      .builder()
      .optionallyWith(
        metricAttributionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.metricAttributionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.UpdateMetricAttributionResponse.ReadOnly =
    zio.aws.personalize.model.UpdateMetricAttributionResponse
      .wrap(buildAwsValue())
}
object UpdateMetricAttributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateMetricAttributionResponse =
      zio.aws.personalize.model.UpdateMetricAttributionResponse(
        metricAttributionArn.map(value => value)
      )
    def metricAttributionArn: Optional[Arn]
    def getMetricAttributionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("metricAttributionArn", metricAttributionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse
  ) extends zio.aws.personalize.model.UpdateMetricAttributionResponse.ReadOnly {
    override val metricAttributionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricAttributionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse
  ): zio.aws.personalize.model.UpdateMetricAttributionResponse.ReadOnly =
    new Wrapper(impl)
}
