package zio.aws.pi
import zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.pi.{PiAsyncClientBuilder, PiAsyncClient}
import software.amazon.awssdk.services.pi.model.{
  GetResourceMetricsResponse,
  GetResourceMetricsRequest,
  MetricDimensionGroups,
  ListAvailableResourceDimensionsResponse,
  ListAvailableResourceMetricsRequest,
  ResponseResourceMetric,
  DimensionKeyDescription,
  ListAvailableResourceDimensionsRequest,
  ListAvailableResourceMetricsResponse,
  GetResourceMetadataRequest,
  DescribeDimensionKeysRequest,
  GetDimensionKeyDetailsRequest,
  GetResourceMetadataResponse,
  GetDimensionKeyDetailsResponse,
  DescribeDimensionKeysResponse,
  MetricKeyDataPoints
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Pi extends AspectSupport[Pi] {
  val api: PiAsyncClient
  def getResourceMetrics(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
    zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
  ]]
  def getResourceMetricsPaginated(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): IO[AwsError, zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly]
  def listAvailableResourceMetrics(
      request: zio.aws.pi.model.ListAvailableResourceMetricsRequest
  ): ZStream[Any, AwsError, zio.aws.pi.model.ResponseResourceMetric.ReadOnly]
  def listAvailableResourceMetricsPaginated(
      request: zio.aws.pi.model.ListAvailableResourceMetricsRequest
  ): IO[AwsError, ReadOnly]
  def getResourceMetadata(
      request: zio.aws.pi.model.GetResourceMetadataRequest
  ): IO[AwsError, zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly]
  def listAvailableResourceDimensions(
      request: zio.aws.pi.model.ListAvailableResourceDimensionsRequest
  ): ZStream[Any, AwsError, zio.aws.pi.model.MetricDimensionGroups.ReadOnly]
  def listAvailableResourceDimensionsPaginated(
      request: zio.aws.pi.model.ListAvailableResourceDimensionsRequest
  ): IO[
    AwsError,
    zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly
  ]
  def describeDimensionKeys(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
    zio.aws.pi.model.DimensionKeyDescription.ReadOnly
  ]]
  def describeDimensionKeysPaginated(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): IO[AwsError, zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly]
  def getDimensionKeyDetails(
      request: zio.aws.pi.model.GetDimensionKeyDetailsRequest
  ): IO[AwsError, zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly]
}
object Pi {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Pi] = customized(identity)
  def customized(
      customization: PiAsyncClientBuilder => PiAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Pi] = managed(customization).toLayer
  def managed(
      customization: PiAsyncClientBuilder => PiAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Pi] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PiAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[PiAsyncClient, PiAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[PiAsyncClient, PiAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new PiImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PiImpl[R](
      override val api: PiAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Pi
      with AwsServiceBase[R] {
    override val serviceName: String = "Pi"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PiImpl[R1] = new PiImpl(api, newAspect, r)
    def getResourceMetrics(
        request: zio.aws.pi.model.GetResourceMetricsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
      zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
    ]] = asyncPaginatedRequest[
      GetResourceMetricsRequest,
      GetResourceMetricsResponse,
      MetricKeyDataPoints
    ](
      "getResourceMetrics",
      api.getResourceMetrics,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metricList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.pi.model.GetResourceMetricsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.pi.model.MetricKeyDataPoints.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getResourceMetricsPaginated(
        request: zio.aws.pi.model.GetResourceMetricsRequest
    ): IO[AwsError, zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly] =
      asyncRequestResponse[
        GetResourceMetricsRequest,
        GetResourceMetricsResponse
      ]("getResourceMetrics", api.getResourceMetrics)(request.buildAwsValue())
        .map(zio.aws.pi.model.GetResourceMetricsResponse.wrap)
        .provideEnvironment(r)
    def listAvailableResourceMetrics(
        request: zio.aws.pi.model.ListAvailableResourceMetricsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pi.model.ResponseResourceMetric.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAvailableResourceMetricsRequest,
      ListAvailableResourceMetricsResponse,
      ResponseResourceMetric
    ](
      "listAvailableResourceMetrics",
      api.listAvailableResourceMetrics,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metrics().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pi.model.ResponseResourceMetric.wrap(item))
      .provideEnvironment(r)
    def listAvailableResourceMetricsPaginated(
        request: zio.aws.pi.model.ListAvailableResourceMetricsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListAvailableResourceMetricsRequest,
      ListAvailableResourceMetricsResponse
    ]("listAvailableResourceMetrics", api.listAvailableResourceMetrics)(
      request.buildAwsValue()
    ).map(zio.aws.pi.model.ListAvailableResourceMetricsResponse.wrap)
      .provideEnvironment(r)
    def getResourceMetadata(
        request: zio.aws.pi.model.GetResourceMetadataRequest
    ): IO[AwsError, zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        GetResourceMetadataRequest,
        GetResourceMetadataResponse
      ]("getResourceMetadata", api.getResourceMetadata)(request.buildAwsValue())
        .map(zio.aws.pi.model.GetResourceMetadataResponse.wrap)
        .provideEnvironment(r)
    def listAvailableResourceDimensions(
        request: zio.aws.pi.model.ListAvailableResourceDimensionsRequest
    ): ZStream[Any, AwsError, zio.aws.pi.model.MetricDimensionGroups.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAvailableResourceDimensionsRequest,
        ListAvailableResourceDimensionsResponse,
        MetricDimensionGroups
      ](
        "listAvailableResourceDimensions",
        api.listAvailableResourceDimensions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.metricDimensions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.pi.model.MetricDimensionGroups.wrap(item))
        .provideEnvironment(r)
    def listAvailableResourceDimensionsPaginated(
        request: zio.aws.pi.model.ListAvailableResourceDimensionsRequest
    ): IO[
      AwsError,
      zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAvailableResourceDimensionsRequest,
      ListAvailableResourceDimensionsResponse
    ]("listAvailableResourceDimensions", api.listAvailableResourceDimensions)(
      request.buildAwsValue()
    ).map(zio.aws.pi.model.ListAvailableResourceDimensionsResponse.wrap)
      .provideEnvironment(r)
    def describeDimensionKeys(
        request: zio.aws.pi.model.DescribeDimensionKeysRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
      zio.aws.pi.model.DimensionKeyDescription.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeDimensionKeysRequest,
      DescribeDimensionKeysResponse,
      DimensionKeyDescription
    ](
      "describeDimensionKeys",
      api.describeDimensionKeys,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.keys().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.pi.model.DescribeDimensionKeysResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.pi.model.DimensionKeyDescription.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeDimensionKeysPaginated(
        request: zio.aws.pi.model.DescribeDimensionKeysRequest
    ): IO[AwsError, zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDimensionKeysRequest,
        DescribeDimensionKeysResponse
      ]("describeDimensionKeys", api.describeDimensionKeys)(
        request.buildAwsValue()
      ).map(zio.aws.pi.model.DescribeDimensionKeysResponse.wrap)
        .provideEnvironment(r)
    def getDimensionKeyDetails(
        request: zio.aws.pi.model.GetDimensionKeyDetailsRequest
    ): IO[AwsError, zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly] =
      asyncRequestResponse[
        GetDimensionKeyDetailsRequest,
        GetDimensionKeyDetailsResponse
      ]("getDimensionKeyDetails", api.getDimensionKeyDetails)(
        request.buildAwsValue()
      ).map(zio.aws.pi.model.GetDimensionKeyDetailsResponse.wrap)
        .provideEnvironment(r)
  }
  def getResourceMetrics(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): ZIO[zio.aws.pi.Pi, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
    zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getResourceMetrics(request))
  def getResourceMetricsPaginated(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceMetricsPaginated(request))
  def listAvailableResourceMetrics(
      request: zio.aws.pi.model.ListAvailableResourceMetricsRequest
  ): ZStream[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.ResponseResourceMetric.ReadOnly
  ] = ZStream.serviceWithStream(_.listAvailableResourceMetrics(request))
  def listAvailableResourceMetricsPaginated(
      request: zio.aws.pi.model.ListAvailableResourceMetricsRequest
  ): ZIO[zio.aws.pi.Pi, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listAvailableResourceMetricsPaginated(request))
  def getResourceMetadata(
      request: zio.aws.pi.model.GetResourceMetadataRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceMetadata(request))
  def listAvailableResourceDimensions(
      request: zio.aws.pi.model.ListAvailableResourceDimensionsRequest
  ): ZStream[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.MetricDimensionGroups.ReadOnly
  ] = ZStream.serviceWithStream(_.listAvailableResourceDimensions(request))
  def listAvailableResourceDimensionsPaginated(
      request: zio.aws.pi.model.ListAvailableResourceDimensionsRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableResourceDimensionsPaginated(request))
  def describeDimensionKeys(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): ZIO[zio.aws.pi.Pi, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
    zio.aws.pi.model.DimensionKeyDescription.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeDimensionKeys(request))
  def describeDimensionKeysPaginated(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDimensionKeysPaginated(request))
  def getDimensionKeyDetails(
      request: zio.aws.pi.model.GetDimensionKeyDetailsRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDimensionKeyDetails(request))
}
