package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DimensionKeyDetail(
    value: Option[String] = None,
    dimension: Option[String] = None,
    status: Option[zio.aws.pi.model.DetailStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionKeyDetail = {
    import DimensionKeyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionKeyDetail
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(dimension.map(value => value: java.lang.String))(
        _.dimension
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionKeyDetail.ReadOnly =
    zio.aws.pi.model.DimensionKeyDetail.wrap(buildAwsValue())
}
object DimensionKeyDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DimensionKeyDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionKeyDetail =
      zio.aws.pi.model.DimensionKeyDetail(
        value.map(value => value),
        dimension.map(value => value),
        status.map(value => value)
      )
    def value: Option[String]
    def dimension: Option[String]
    def status: Option[zio.aws.pi.model.DetailStatus]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getDimension: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dimension", dimension)
    def getStatus: ZIO[Any, AwsError, zio.aws.pi.model.DetailStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDetail
  ) extends zio.aws.pi.model.DimensionKeyDetail.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val dimension: Option[String] =
      scala.Option(impl.dimension()).map(value => value: String)
    override val status: Option[zio.aws.pi.model.DetailStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.pi.model.DetailStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDetail
  ): zio.aws.pi.model.DimensionKeyDetail.ReadOnly = new Wrapper(impl)
}
