package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FeatureMetadata(
    status: Option[zio.aws.pi.model.FeatureStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.FeatureMetadata = {
    import FeatureMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.FeatureMetadata
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.FeatureMetadata.ReadOnly =
    zio.aws.pi.model.FeatureMetadata.wrap(buildAwsValue())
}
object FeatureMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.FeatureMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.FeatureMetadata =
      zio.aws.pi.model.FeatureMetadata(status.map(value => value))
    def status: Option[zio.aws.pi.model.FeatureStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.pi.model.FeatureStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.FeatureMetadata
  ) extends zio.aws.pi.model.FeatureMetadata.ReadOnly {
    override val status: Option[zio.aws.pi.model.FeatureStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.pi.model.FeatureStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.FeatureMetadata
  ): zio.aws.pi.model.FeatureMetadata.ReadOnly = new Wrapper(impl)
}
