package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDimensionKeyDetailsResponse(
    dimensions: Option[Iterable[zio.aws.pi.model.DimensionKeyDetail]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsResponse = {
    import GetDimensionKeyDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsResponse
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly =
    zio.aws.pi.model.GetDimensionKeyDetailsResponse.wrap(buildAwsValue())
}
object GetDimensionKeyDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetDimensionKeyDetailsResponse =
      zio.aws.pi.model.GetDimensionKeyDetailsResponse(
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dimensions: Option[List[zio.aws.pi.model.DimensionKeyDetail.ReadOnly]]
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.pi.model.DimensionKeyDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsResponse
  ) extends zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly {
    override val dimensions
        : Option[List[zio.aws.pi.model.DimensionKeyDetail.ReadOnly]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.DimensionKeyDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsResponse
  ): zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly = new Wrapper(
    impl
  )
}
