package zio.aws.pi.model
import java.lang.Integer
import zio.aws.pi.model.primitives.{MaxResults, NextToken, RequestString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAvailableResourceMetricsRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: RequestString,
    metricTypes: Iterable[RequestString],
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest = {
    import ListAvailableResourceMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(RequestString.unwrap(identifier): java.lang.String)
      .metricTypes(metricTypes.map { item =>
        RequestString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListAvailableResourceMetricsRequest.ReadOnly =
    zio.aws.pi.model.ListAvailableResourceMetricsRequest.wrap(buildAwsValue())
}
object ListAvailableResourceMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListAvailableResourceMetricsRequest =
      zio.aws.pi.model.ListAvailableResourceMetricsRequest(
        serviceType,
        identifier,
        metricTypes,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: RequestString
    def metricTypes: List[RequestString]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, RequestString] =
      ZIO.succeed(identifier)
    def getMetricTypes: ZIO[Any, Nothing, List[RequestString]] =
      ZIO.succeed(metricTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
  ) extends zio.aws.pi.model.ListAvailableResourceMetricsRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.identifier())
    override val metricTypes: List[RequestString] = impl
      .metricTypes()
      .asScala
      .map { item =>
        zio.aws.pi.model.primitives.RequestString(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest
  ): zio.aws.pi.model.ListAvailableResourceMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
