package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricDimensionGroups(
    metric: Option[String] = None,
    groups: Option[Iterable[zio.aws.pi.model.DimensionGroupDetail]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.MetricDimensionGroups = {
    import MetricDimensionGroups.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.MetricDimensionGroups
      .builder()
      .optionallyWith(metric.map(value => value: java.lang.String))(_.metric)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.MetricDimensionGroups.ReadOnly =
    zio.aws.pi.model.MetricDimensionGroups.wrap(buildAwsValue())
}
object MetricDimensionGroups {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.MetricDimensionGroups
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.MetricDimensionGroups =
      zio.aws.pi.model.MetricDimensionGroups(
        metric.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metric: Option[String]
    def groups: Option[List[zio.aws.pi.model.DimensionGroupDetail.ReadOnly]]
    def getMetric: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metric", metric)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.pi.model.DimensionGroupDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.MetricDimensionGroups
  ) extends zio.aws.pi.model.MetricDimensionGroups.ReadOnly {
    override val metric: Option[String] =
      scala.Option(impl.metric()).map(value => value: String)
    override val groups
        : Option[List[zio.aws.pi.model.DimensionGroupDetail.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.DimensionGroupDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.MetricDimensionGroups
  ): zio.aws.pi.model.MetricDimensionGroups.ReadOnly = new Wrapper(impl)
}
