package zio.aws.pi.model
import zio.aws.pi.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseResourceMetric(
    metric: Option[String] = None,
    description: Option[Description] = None,
    unit: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ResponseResourceMetric = {
    import ResponseResourceMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ResponseResourceMetric
      .builder()
      .optionallyWith(metric.map(value => value: java.lang.String))(_.metric)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.ResponseResourceMetric.ReadOnly =
    zio.aws.pi.model.ResponseResourceMetric.wrap(buildAwsValue())
}
object ResponseResourceMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ResponseResourceMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ResponseResourceMetric =
      zio.aws.pi.model.ResponseResourceMetric(
        metric.map(value => value),
        description.map(value => value),
        unit.map(value => value)
      )
    def metric: Option[String]
    def description: Option[Description]
    def unit: Option[String]
    def getMetric: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metric", metric)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ResponseResourceMetric
  ) extends zio.aws.pi.model.ResponseResourceMetric.ReadOnly {
    override val metric: Option[String] =
      scala.Option(impl.metric()).map(value => value: String)
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.pi.model.primitives.Description(value))
    override val unit: Option[String] =
      scala.Option(impl.unit()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ResponseResourceMetric
  ): zio.aws.pi.model.ResponseResourceMetric.ReadOnly = new Wrapper(impl)
}
