package zio.aws.pi.model
import zio.aws.pi.model.primitives.ISOTimestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DataPoint(timestamp: ISOTimestamp, value: Double) {
  def buildAwsValue(): software.amazon.awssdk.services.pi.model.DataPoint = {
    import DataPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DataPoint
      .builder()
      .timestamp(ISOTimestamp.unwrap(timestamp): Instant)
      .value(value: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DataPoint.ReadOnly =
    zio.aws.pi.model.DataPoint.wrap(buildAwsValue())
}
object DataPoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.DataPoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DataPoint =
      zio.aws.pi.model.DataPoint(timestamp, value)
    def timestamp: ISOTimestamp
    def value: Double
    def getTimestamp: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(timestamp)
    def getValue: ZIO[Any, Nothing, Double] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DataPoint
  ) extends zio.aws.pi.model.DataPoint.ReadOnly {
    override val timestamp: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.timestamp())
    override val value: Double = impl.value(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DataPoint
  ): zio.aws.pi.model.DataPoint.ReadOnly = new Wrapper(impl)
}
