package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{NextToken, ISOTimestamp}
import scala.jdk.CollectionConverters._
final case class DescribeDimensionKeysResponse(
    alignedStartTime: Optional[ISOTimestamp] = Optional.Absent,
    alignedEndTime: Optional[ISOTimestamp] = Optional.Absent,
    partitionKeys: Optional[Iterable[zio.aws.pi.model.ResponsePartitionKey]] =
      Optional.Absent,
    keys: Optional[Iterable[zio.aws.pi.model.DimensionKeyDescription]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse = {
    import DescribeDimensionKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
      .builder()
      .optionallyWith(
        alignedStartTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedStartTime)
      .optionallyWith(
        alignedEndTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedEndTime)
      .optionallyWith(
        partitionKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partitionKeys)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly =
    zio.aws.pi.model.DescribeDimensionKeysResponse.wrap(buildAwsValue())
}
object DescribeDimensionKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DescribeDimensionKeysResponse =
      zio.aws.pi.model.DescribeDimensionKeysResponse(
        alignedStartTime.map(value => value),
        alignedEndTime.map(value => value),
        partitionKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def alignedStartTime: Optional[ISOTimestamp]
    def alignedEndTime: Optional[ISOTimestamp]
    def partitionKeys
        : Optional[List[zio.aws.pi.model.ResponsePartitionKey.ReadOnly]]
    def keys: Optional[List[zio.aws.pi.model.DimensionKeyDescription.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAlignedStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedStartTime", alignedStartTime)
    def getAlignedEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedEndTime", alignedEndTime)
    def getPartitionKeys: ZIO[Any, AwsError, List[
      zio.aws.pi.model.ResponsePartitionKey.ReadOnly
    ]] = AwsError.unwrapOptionField("partitionKeys", partitionKeys)
    def getKeys: ZIO[Any, AwsError, List[
      zio.aws.pi.model.DimensionKeyDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("keys", keys)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
  ) extends zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly {
    override val alignedStartTime: Optional[ISOTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alignedStartTime())
        .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val alignedEndTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.alignedEndTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val partitionKeys
        : Optional[List[zio.aws.pi.model.ResponsePartitionKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.ResponsePartitionKey.wrap(item)
          }.toList
        )
    override val keys
        : Optional[List[zio.aws.pi.model.DimensionKeyDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.DimensionKeyDescription.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
  ): zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly = new Wrapper(impl)
}
