package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DimensionKeyDetail(
    value: Optional[String] = Optional.Absent,
    dimension: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.pi.model.DetailStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionKeyDetail = {
    import DimensionKeyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionKeyDetail
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(dimension.map(value => value: java.lang.String))(
        _.dimension
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionKeyDetail.ReadOnly =
    zio.aws.pi.model.DimensionKeyDetail.wrap(buildAwsValue())
}
object DimensionKeyDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DimensionKeyDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionKeyDetail =
      zio.aws.pi.model.DimensionKeyDetail(
        value.map(value => value),
        dimension.map(value => value),
        status.map(value => value)
      )
    def value: Optional[String]
    def dimension: Optional[String]
    def status: Optional[zio.aws.pi.model.DetailStatus]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getDimension: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dimension", dimension)
    def getStatus: ZIO[Any, AwsError, zio.aws.pi.model.DetailStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDetail
  ) extends zio.aws.pi.model.DimensionKeyDetail.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val dimension: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dimension())
      .map(value => value: String)
    override val status: Optional[zio.aws.pi.model.DetailStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.pi.model.DetailStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDetail
  ): zio.aws.pi.model.DimensionKeyDetail.ReadOnly = new Wrapper(impl)
}
