package zio.aws.pi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricKeyDataPoints(
    key: Optional[zio.aws.pi.model.ResponseResourceMetricKey] = Optional.Absent,
    dataPoints: Optional[Iterable[zio.aws.pi.model.DataPoint]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.MetricKeyDataPoints = {
    import MetricKeyDataPoints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.MetricKeyDataPoints
      .builder()
      .optionallyWith(key.map(value => value.buildAwsValue()))(_.key)
      .optionallyWith(
        dataPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataPoints)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.MetricKeyDataPoints.ReadOnly =
    zio.aws.pi.model.MetricKeyDataPoints.wrap(buildAwsValue())
}
object MetricKeyDataPoints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.MetricKeyDataPoints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.MetricKeyDataPoints =
      zio.aws.pi.model.MetricKeyDataPoints(
        key.map(value => value.asEditable),
        dataPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def key: Optional[zio.aws.pi.model.ResponseResourceMetricKey.ReadOnly]
    def dataPoints: Optional[List[zio.aws.pi.model.DataPoint.ReadOnly]]
    def getKey: ZIO[
      Any,
      AwsError,
      zio.aws.pi.model.ResponseResourceMetricKey.ReadOnly
    ] = AwsError.unwrapOptionField("key", key)
    def getDataPoints
        : ZIO[Any, AwsError, List[zio.aws.pi.model.DataPoint.ReadOnly]] =
      AwsError.unwrapOptionField("dataPoints", dataPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.MetricKeyDataPoints
  ) extends zio.aws.pi.model.MetricKeyDataPoints.ReadOnly {
    override val key
        : Optional[zio.aws.pi.model.ResponseResourceMetricKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value => zio.aws.pi.model.ResponseResourceMetricKey.wrap(value))
    override val dataPoints
        : Optional[List[zio.aws.pi.model.DataPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.DataPoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.MetricKeyDataPoints
  ): zio.aws.pi.model.MetricKeyDataPoints.ReadOnly = new Wrapper(impl)
}
