package zio.aws.pi
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.pi.{PiAsyncClientBuilder, PiAsyncClient}
import zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
import software.amazon.awssdk.services.pi.model.{
  GetResourceMetricsResponse,
  GetResourceMetricsRequest,
  DimensionKeyDescription,
  DescribeDimensionKeysRequest,
  GetDimensionKeyDetailsRequest,
  GetDimensionKeyDetailsResponse,
  DescribeDimensionKeysResponse,
  MetricKeyDataPoints
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters.*
trait Pi extends AspectSupport[Pi] {
  val api: PiAsyncClient
  def describeDimensionKeys(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
    zio.aws.pi.model.DimensionKeyDescription.ReadOnly
  ]]
  def describeDimensionKeysPaginated(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): IO[AwsError, zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly]
  def getDimensionKeyDetails(
      request: zio.aws.pi.model.GetDimensionKeyDetailsRequest
  ): IO[AwsError, zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly]
  def getResourceMetrics(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
    ReadOnly
  ]]
  def getResourceMetricsPaginated(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): IO[AwsError, zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly]
}
object Pi {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Pi] = customized(identity)
  def customized(
      customization: PiAsyncClientBuilder => PiAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Pi] = managed(customization).toLayer
  def managed(
      customization: PiAsyncClientBuilder => PiAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Pi] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PiAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[PiAsyncClient, PiAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[PiAsyncClient, PiAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new PiImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PiImpl[R](
      override val api: PiAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Pi
      with AwsServiceBase[R] {
    override val serviceName: String = "Pi"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PiImpl[R1] = new PiImpl(api, newAspect, r)
    def describeDimensionKeys(
        request: zio.aws.pi.model.DescribeDimensionKeysRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
      zio.aws.pi.model.DimensionKeyDescription.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeDimensionKeysRequest,
      DescribeDimensionKeysResponse,
      DimensionKeyDescription
    ](
      "describeDimensionKeys",
      api.describeDimensionKeys,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.keys().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.pi.model.DescribeDimensionKeysResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.pi.model.DimensionKeyDescription.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeDimensionKeysPaginated(
        request: zio.aws.pi.model.DescribeDimensionKeysRequest
    ): IO[AwsError, zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDimensionKeysRequest,
        DescribeDimensionKeysResponse
      ]("describeDimensionKeys", api.describeDimensionKeys)(
        request.buildAwsValue()
      ).map(zio.aws.pi.model.DescribeDimensionKeysResponse.wrap)
        .provideEnvironment(r)
    def getDimensionKeyDetails(
        request: zio.aws.pi.model.GetDimensionKeyDetailsRequest
    ): IO[AwsError, zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly] =
      asyncRequestResponse[
        GetDimensionKeyDetailsRequest,
        GetDimensionKeyDetailsResponse
      ]("getDimensionKeyDetails", api.getDimensionKeyDetails)(
        request.buildAwsValue()
      ).map(zio.aws.pi.model.GetDimensionKeyDetailsResponse.wrap)
        .provideEnvironment(r)
    def getResourceMetrics(
        request: zio.aws.pi.model.GetResourceMetricsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
      ReadOnly
    ]] = asyncPaginatedRequest[
      GetResourceMetricsRequest,
      GetResourceMetricsResponse,
      MetricKeyDataPoints
    ](
      "getResourceMetrics",
      api.getResourceMetrics,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metricList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.pi.model.GetResourceMetricsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.pi.model.MetricKeyDataPoints.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getResourceMetricsPaginated(
        request: zio.aws.pi.model.GetResourceMetricsRequest
    ): IO[AwsError, zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly] =
      asyncRequestResponse[
        GetResourceMetricsRequest,
        GetResourceMetricsResponse
      ]("getResourceMetrics", api.getResourceMetrics)(request.buildAwsValue())
        .map(zio.aws.pi.model.GetResourceMetricsResponse.wrap)
        .provideEnvironment(r)
  }
  def describeDimensionKeys(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): ZIO[zio.aws.pi.Pi, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
    zio.aws.pi.model.DimensionKeyDescription.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeDimensionKeys(request))
  def describeDimensionKeysPaginated(
      request: zio.aws.pi.model.DescribeDimensionKeysRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDimensionKeysPaginated(request))
  def getDimensionKeyDetails(
      request: zio.aws.pi.model.GetDimensionKeyDetailsRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDimensionKeyDetails(request))
  def getResourceMetrics(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): ZIO[zio.aws.pi.Pi, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
    ReadOnly
  ]] = ZIO.serviceWithZIO(_.getResourceMetrics(request))
  def getResourceMetricsPaginated(
      request: zio.aws.pi.model.GetResourceMetricsRequest
  ): ZIO[
    zio.aws.pi.Pi,
    AwsError,
    zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceMetricsPaginated(request))
}
