package zio.aws.pi
import software.amazon.awssdk.services.pi.PiAsyncClient
import zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
import zio.aws.pi.model.{
  GetResourceMetricsRequest,
  GetDimensionKeyDetailsRequest,
  DescribeDimensionKeysRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZIO, ZEnvironment, URLayer}
import zio.test.mock.{Proxy, Mock}
object PiMock extends Mock[Pi] {
  object DescribeDimensionKeys
      extends Effect[
        DescribeDimensionKeysRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
          zio.aws.pi.model.DimensionKeyDescription.ReadOnly
        ]
      ]
  object DescribeDimensionKeysPaginated
      extends Effect[
        DescribeDimensionKeysRequest,
        AwsError,
        zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly
      ]
  object GetDimensionKeyDetails
      extends Effect[
        GetDimensionKeyDetailsRequest,
        AwsError,
        zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly
      ]
  object GetResourceMetrics
      extends Effect[GetResourceMetricsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
        ReadOnly
      ]]
  object GetResourceMetricsPaginated
      extends Effect[
        GetResourceMetricsRequest,
        AwsError,
        zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Pi] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Pi {
          val api: PiAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Pi = this
          def describeDimensionKeys(
              request: DescribeDimensionKeysRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
            zio.aws.pi.model.DimensionKeyDescription.ReadOnly
          ]] = proxy(DescribeDimensionKeys, request)
          def describeDimensionKeysPaginated(
              request: DescribeDimensionKeysRequest
          ): IO[
            AwsError,
            zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly
          ] = proxy(DescribeDimensionKeysPaginated, request)
          def getDimensionKeyDetails(
              request: GetDimensionKeyDetailsRequest
          ): IO[
            AwsError,
            zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly
          ] = proxy(GetDimensionKeyDetails, request)
          def getResourceMetrics(
              request: GetResourceMetricsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
            ReadOnly
          ]] = proxy(GetResourceMetrics, request)
          def getResourceMetricsPaginated(
              request: GetResourceMetricsRequest
          ): IO[
            AwsError,
            zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly
          ] = proxy(GetResourceMetricsPaginated, request)
        }
      }
    }
    .toLayer
}
