package zio.aws.pi.model
import scala.jdk.CollectionConverters.*
sealed trait DetailStatus {
  def unwrap: software.amazon.awssdk.services.pi.model.DetailStatus
}
object DetailStatus {
  def wrap(
      value: software.amazon.awssdk.services.pi.model.DetailStatus
  ): zio.aws.pi.model.DetailStatus = value match {
    case software.amazon.awssdk.services.pi.model.DetailStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pi.model.DetailStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.pi.model.DetailStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.pi.model.DetailStatus.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pi.model.DetailStatus {
    override def unwrap: software.amazon.awssdk.services.pi.model.DetailStatus =
      software.amazon.awssdk.services.pi.model.DetailStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.pi.model.DetailStatus {
    override def unwrap: software.amazon.awssdk.services.pi.model.DetailStatus =
      software.amazon.awssdk.services.pi.model.DetailStatus.AVAILABLE
  }
  case object PROCESSING extends zio.aws.pi.model.DetailStatus {
    override def unwrap: software.amazon.awssdk.services.pi.model.DetailStatus =
      software.amazon.awssdk.services.pi.model.DetailStatus.PROCESSING
  }
  case object UNAVAILABLE extends zio.aws.pi.model.DetailStatus {
    override def unwrap: software.amazon.awssdk.services.pi.model.DetailStatus =
      software.amazon.awssdk.services.pi.model.DetailStatus.UNAVAILABLE
  }
}
