package zio.aws.pi.model
import java.lang.Integer
import zio.aws.pi.model.primitives.{Limit, RequestString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DimensionGroup(
    group: RequestString,
    dimensions: Option[Iterable[RequestString]] = None,
    limit: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionGroup = {
    import DimensionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionGroup
      .builder()
      .group(RequestString.unwrap(group): java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            RequestString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionGroup.ReadOnly =
    zio.aws.pi.model.DimensionGroup.wrap(buildAwsValue())
}
object DimensionGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.DimensionGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionGroup =
      zio.aws.pi.model.DimensionGroup(
        group,
        dimensions.map(value => value),
        limit.map(value => value)
      )
    def group: RequestString
    def dimensions: Option[List[RequestString]]
    def limit: Option[Limit]
    def getGroup: ZIO[Any, Nothing, RequestString] = ZIO.succeed(group)
    def getDimensions: ZIO[Any, AwsError, List[RequestString]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionGroup
  ) extends zio.aws.pi.model.DimensionGroup.ReadOnly {
    override val group: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.group())
    override val dimensions: Option[List[RequestString]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.primitives.RequestString(item)
        }.toList
      )
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.pi.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionGroup
  ): zio.aws.pi.model.DimensionGroup.ReadOnly = new Wrapper(impl)
}
