package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DimensionKeyDescription(
    dimensions: Option[Map[RequestString, RequestString]] = None,
    total: Option[Double] = None,
    partitions: Option[Iterable[Double]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DimensionKeyDescription = {
    import DimensionKeyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DimensionKeyDescription
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dimensions)
      .optionallyWith(total.map(value => value: java.lang.Double))(_.total)
      .optionallyWith(
        partitions.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.partitions)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DimensionKeyDescription.ReadOnly =
    zio.aws.pi.model.DimensionKeyDescription.wrap(buildAwsValue())
}
object DimensionKeyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DimensionKeyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DimensionKeyDescription =
      zio.aws.pi.model.DimensionKeyDescription(
        dimensions.map(value => value),
        total.map(value => value),
        partitions.map(value => value)
      )
    def dimensions: Option[Map[RequestString, RequestString]]
    def total: Option[Double]
    def partitions: Option[List[Double]]
    def getDimensions: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getTotal: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("total", total)
    def getPartitions: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("partitions", partitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDescription
  ) extends zio.aws.pi.model.DimensionKeyDescription.ReadOnly {
    override val dimensions: Option[Map[RequestString, RequestString]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pi.model.primitives.RequestString(
              key
            ) -> zio.aws.pi.model.primitives.RequestString(value)
          })
          .toMap
      )
    override val total: Option[Double] =
      scala.Option(impl.total()).map(value => value: Double)
    override val partitions: Option[List[Double]] = scala
      .Option(impl.partitions())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DimensionKeyDescription
  ): zio.aws.pi.model.DimensionKeyDescription.ReadOnly = new Wrapper(impl)
}
