package zio.aws.pi.model
import zio.aws.pi.model.primitives.{RequestString, IdentifierString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDimensionKeyDetailsRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: IdentifierString,
    group: RequestString,
    groupIdentifier: RequestString,
    requestedDimensions: Option[Iterable[RequestString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest = {
    import GetDimensionKeyDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(IdentifierString.unwrap(identifier): java.lang.String)
      .group(RequestString.unwrap(group): java.lang.String)
      .groupIdentifier(RequestString.unwrap(groupIdentifier): java.lang.String)
      .optionallyWith(
        requestedDimensions.map(value =>
          value.map { item =>
            RequestString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requestedDimensions)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetDimensionKeyDetailsRequest.ReadOnly =
    zio.aws.pi.model.GetDimensionKeyDetailsRequest.wrap(buildAwsValue())
}
object GetDimensionKeyDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetDimensionKeyDetailsRequest =
      zio.aws.pi.model.GetDimensionKeyDetailsRequest(
        serviceType,
        identifier,
        group,
        groupIdentifier,
        requestedDimensions.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: IdentifierString
    def group: RequestString
    def groupIdentifier: RequestString
    def requestedDimensions: Option[List[RequestString]]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, IdentifierString] =
      ZIO.succeed(identifier)
    def getGroup: ZIO[Any, Nothing, RequestString] = ZIO.succeed(group)
    def getGroupIdentifier: ZIO[Any, Nothing, RequestString] =
      ZIO.succeed(groupIdentifier)
    def getRequestedDimensions: ZIO[Any, AwsError, List[RequestString]] =
      AwsError.unwrapOptionField("requestedDimensions", requestedDimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest
  ) extends zio.aws.pi.model.GetDimensionKeyDetailsRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: IdentifierString =
      zio.aws.pi.model.primitives.IdentifierString(impl.identifier())
    override val group: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.group())
    override val groupIdentifier: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.groupIdentifier())
    override val requestedDimensions: Option[List[RequestString]] = scala
      .Option(impl.requestedDimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.primitives.RequestString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest
  ): zio.aws.pi.model.GetDimensionKeyDetailsRequest.ReadOnly = new Wrapper(impl)
}
