package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricQuery(
    metric: RequestString,
    groupBy: Option[zio.aws.pi.model.DimensionGroup] = None,
    filter: Option[Map[RequestString, RequestString]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.pi.model.MetricQuery = {
    import MetricQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.MetricQuery
      .builder()
      .metric(RequestString.unwrap(metric): java.lang.String)
      .optionallyWith(groupBy.map(value => value.buildAwsValue()))(_.groupBy)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.MetricQuery.ReadOnly =
    zio.aws.pi.model.MetricQuery.wrap(buildAwsValue())
}
object MetricQuery {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.MetricQuery] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.MetricQuery = zio.aws.pi.model.MetricQuery(
      metric,
      groupBy.map(value => value.asEditable),
      filter.map(value => value)
    )
    def metric: RequestString
    def groupBy: Option[zio.aws.pi.model.DimensionGroup.ReadOnly]
    def filter: Option[Map[RequestString, RequestString]]
    def getMetric: ZIO[Any, Nothing, RequestString] = ZIO.succeed(metric)
    def getGroupBy
        : ZIO[Any, AwsError, zio.aws.pi.model.DimensionGroup.ReadOnly] =
      AwsError.unwrapOptionField("groupBy", groupBy)
    def getFilter: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.MetricQuery
  ) extends zio.aws.pi.model.MetricQuery.ReadOnly {
    override val metric: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.metric())
    override val groupBy: Option[zio.aws.pi.model.DimensionGroup.ReadOnly] =
      scala
        .Option(impl.groupBy())
        .map(value => zio.aws.pi.model.DimensionGroup.wrap(value))
    override val filter: Option[Map[RequestString, RequestString]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pi.model.primitives.RequestString(
              key
            ) -> zio.aws.pi.model.primitives.RequestString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.MetricQuery
  ): zio.aws.pi.model.MetricQuery.ReadOnly = new Wrapper(impl)
}
