package zio.aws.pinpoint
import zio.aws.pinpoint.model.CreateExportJobResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.pinpoint.PinpointAsyncClient
import zio.aws.pinpoint.model.{
  CreateAppRequest,
  GetJourneyRequest,
  GetJourneyExecutionActivityMetricsRequest,
  UpdateApnsChannelRequest,
  UpdateVoiceChannelRequest,
  UpdateAdmChannelRequest,
  GetSegmentVersionRequest,
  CreateExportJobRequest,
  GetSegmentRequest,
  GetCampaignVersionRequest,
  CreatePushTemplateRequest,
  GetApplicationDateRangeKpiRequest,
  GetVoiceChannelRequest,
  DeleteEndpointRequest,
  DeletePushTemplateRequest,
  GetApnsVoipChannelRequest,
  GetApnsVoipSandboxChannelRequest,
  GetJourneyExecutionMetricsRequest,
  UpdateTemplateActiveVersionRequest,
  DeleteVoiceChannelRequest,
  GetJourneyDateRangeKpiRequest,
  GetExportJobRequest,
  DeleteJourneyRequest,
  GetSegmentExportJobsRequest,
  GetGcmChannelRequest,
  GetPushTemplateRequest,
  CreateInAppTemplateRequest,
  GetVoiceTemplateRequest,
  SendUsersMessagesRequest,
  RemoveAttributesRequest,
  DeleteApnsChannelRequest,
  UpdateVoiceTemplateRequest,
  UpdateEndpointsBatchRequest,
  UpdateRecommenderConfigurationRequest,
  DeleteInAppTemplateRequest,
  DeleteApnsVoipChannelRequest,
  GetCampaignActivitiesRequest,
  CreateRecommenderConfigurationRequest,
  UpdateBaiduChannelRequest,
  SendOtpMessageRequest,
  GetExportJobsRequest,
  UpdateEndpointRequest,
  GetEmailChannelRequest,
  GetCampaignsRequest,
  ListTagsForResourceRequest,
  DeleteAdmChannelRequest,
  DeleteBaiduChannelRequest,
  DeleteUserEndpointsRequest,
  VerifyOtpMessageRequest,
  UpdateSmsChannelRequest,
  UpdateCampaignRequest,
  GetCampaignRequest,
  DeleteSegmentRequest,
  UpdateEmailTemplateRequest,
  ListJourneysRequest,
  GetEmailTemplateRequest,
  GetImportJobsRequest,
  UpdateApplicationSettingsRequest,
  UpdateSegmentRequest,
  UpdateInAppTemplateRequest,
  GetSegmentsRequest,
  GetSegmentImportJobsRequest,
  GetRecommenderConfigurationsRequest,
  GetBaiduChannelRequest,
  ListTemplateVersionsRequest,
  GetSegmentVersionsRequest,
  UpdateApnsVoipSandboxChannelRequest,
  UpdateGcmChannelRequest,
  DeleteGcmChannelRequest,
  UpdateApnsSandboxChannelRequest,
  UpdateSmsTemplateRequest,
  DeleteSmsTemplateRequest,
  DeleteSmsChannelRequest,
  CreateVoiceTemplateRequest,
  CreateCampaignRequest,
  GetCampaignVersionsRequest,
  GetInAppTemplateRequest,
  GetApnsChannelRequest,
  DeleteCampaignRequest,
  UpdatePushTemplateRequest,
  GetEndpointRequest,
  GetApnsSandboxChannelRequest,
  GetEventStreamRequest,
  UpdateJourneyRequest,
  GetAppRequest,
  GetImportJobRequest,
  DeleteEmailTemplateRequest,
  GetAppsRequest,
  UpdateApnsVoipChannelRequest,
  UntagResourceRequest,
  PutEventsRequest,
  CreateSegmentRequest,
  DeleteRecommenderConfigurationRequest,
  GetAdmChannelRequest,
  CreateJourneyRequest,
  GetChannelsRequest,
  CreateEmailTemplateRequest,
  GetApplicationSettingsRequest,
  DeleteEmailChannelRequest,
  GetSmsChannelRequest,
  CreateSmsTemplateRequest,
  GetInAppMessagesRequest,
  ListTemplatesRequest,
  SendMessagesRequest,
  DeleteVoiceTemplateRequest,
  PutEventStreamRequest,
  GetRecommenderConfigurationRequest,
  GetSmsTemplateRequest,
  DeleteAppRequest,
  UpdateEmailChannelRequest,
  CreateImportJobRequest,
  GetCampaignDateRangeKpiRequest,
  DeleteEventStreamRequest,
  DeleteApnsVoipSandboxChannelRequest,
  PhoneNumberValidateRequest,
  TagResourceRequest,
  GetUserEndpointsRequest,
  DeleteApnsSandboxChannelRequest,
  UpdateJourneyStateRequest
}
import zio.test.mock.{Proxy, Mock}
object PinpointMock extends Mock[Pinpoint] {
  object DeleteSegment
      extends Effect[
        DeleteSegmentRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly
      ]
  object GetInAppMessages
      extends Effect[
        GetInAppMessagesRequest,
        AwsError,
        zio.aws.pinpoint.model.GetInAppMessagesResponse.ReadOnly
      ]
  object GetEndpoint
      extends Effect[
        GetEndpointRequest,
        AwsError,
        zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly
      ]
  object GetEventStream
      extends Effect[
        GetEventStreamRequest,
        AwsError,
        zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly
      ]
  object GetEmailChannel
      extends Effect[
        GetEmailChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly
      ]
  object UpdateEndpointsBatch
      extends Effect[
        UpdateEndpointsBatchRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly
      ]
  object GetApps
      extends Effect[
        GetAppsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetAppsResponse.ReadOnly
      ]
  object SendMessages
      extends Effect[
        SendMessagesRequest,
        AwsError,
        zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly
      ]
  object GetApplicationSettings
      extends Effect[
        GetApplicationSettingsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly
      ]
  object GetSegmentVersion
      extends Effect[
        GetSegmentVersionRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly
      ]
  object DeleteCampaign
      extends Effect[
        DeleteCampaignRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly
      ]
  object GetCampaign
      extends Effect[
        GetCampaignRequest,
        AwsError,
        zio.aws.pinpoint.model.GetCampaignResponse.ReadOnly
      ]
  object GetUserEndpoints
      extends Effect[
        GetUserEndpointsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetUserEndpointsResponse.ReadOnly
      ]
  object GetApp
      extends Effect[
        GetAppRequest,
        AwsError,
        zio.aws.pinpoint.model.GetAppResponse.ReadOnly
      ]
  object GetCampaignDateRangeKpi
      extends Effect[
        GetCampaignDateRangeKpiRequest,
        AwsError,
        zio.aws.pinpoint.model.GetCampaignDateRangeKpiResponse.ReadOnly
      ]
  object DeleteApnsSandboxChannel
      extends Effect[
        DeleteApnsSandboxChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteApnsSandboxChannelResponse.ReadOnly
      ]
  object GetAdmChannel
      extends Effect[
        GetAdmChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetAdmChannelResponse.ReadOnly
      ]
  object GetJourneyExecutionActivityMetrics
      extends Effect[
        GetJourneyExecutionActivityMetricsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsResponse.ReadOnly
      ]
  object UpdateApnsSandboxChannel
      extends Effect[
        UpdateApnsSandboxChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateApnsSandboxChannelResponse.ReadOnly
      ]
  object GetApnsChannel
      extends Effect[
        GetApnsChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetApnsChannelResponse.ReadOnly
      ]
  object GetEmailTemplate
      extends Effect[
        GetEmailTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.GetEmailTemplateResponse.ReadOnly
      ]
  object ListJourneys
      extends Effect[
        ListJourneysRequest,
        AwsError,
        zio.aws.pinpoint.model.ListJourneysResponse.ReadOnly
      ]
  object SendOTPMessage
      extends Effect[
        SendOtpMessageRequest,
        AwsError,
        zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly
      ]
  object CreateEmailTemplate
      extends Effect[
        CreateEmailTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateEmailTemplateResponse.ReadOnly
      ]
  object RemoveAttributes
      extends Effect[
        RemoveAttributesRequest,
        AwsError,
        zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly
      ]
  object CreatePushTemplate
      extends Effect[
        CreatePushTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.CreatePushTemplateResponse.ReadOnly
      ]
  object GetCampaignVersion
      extends Effect[
        GetCampaignVersionRequest,
        AwsError,
        zio.aws.pinpoint.model.GetCampaignVersionResponse.ReadOnly
      ]
  object UpdateSegment
      extends Effect[
        UpdateSegmentRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly
      ]
  object GetCampaignVersions
      extends Effect[
        GetCampaignVersionsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetCampaignVersionsResponse.ReadOnly
      ]
  object UpdateBaiduChannel
      extends Effect[
        UpdateBaiduChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateBaiduChannelResponse.ReadOnly
      ]
  object CreateSmsTemplate
      extends Effect[
        CreateSmsTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateSmsTemplateResponse.ReadOnly
      ]
  object CreateJourney
      extends Effect[
        CreateJourneyRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateJourneyResponse.ReadOnly
      ]
  object GetImportJobs
      extends Effect[
        GetImportJobsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetImportJobsResponse.ReadOnly
      ]
  object GetExportJob
      extends Effect[
        GetExportJobRequest,
        AwsError,
        zio.aws.pinpoint.model.GetExportJobResponse.ReadOnly
      ]
  object GetCampaigns
      extends Effect[
        GetCampaignsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetCampaignsResponse.ReadOnly
      ]
  object UpdateApplicationSettings
      extends Effect[
        UpdateApplicationSettingsRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly
      ]
  object GetVoiceChannel
      extends Effect[
        GetVoiceChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetVoiceChannelResponse.ReadOnly
      ]
  object GetSmsTemplate
      extends Effect[
        GetSmsTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSmsTemplateResponse.ReadOnly
      ]
  object UpdateEmailChannel
      extends Effect[
        UpdateEmailChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly
      ]
  object GetSegmentImportJobs
      extends Effect[
        GetSegmentImportJobsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSegmentImportJobsResponse.ReadOnly
      ]
  object PhoneNumberValidate
      extends Effect[
        PhoneNumberValidateRequest,
        AwsError,
        zio.aws.pinpoint.model.PhoneNumberValidateResponse.ReadOnly
      ]
  object DeleteEventStream
      extends Effect[
        DeleteEventStreamRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly
      ]
  object DeleteAdmChannel
      extends Effect[
        DeleteAdmChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteAdmChannelResponse.ReadOnly
      ]
  object UpdateInAppTemplate
      extends Effect[
        UpdateInAppTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateInAppTemplateResponse.ReadOnly
      ]
  object GetChannels
      extends Effect[
        GetChannelsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetChannelsResponse.ReadOnly
      ]
  object UpdateApnsChannel
      extends Effect[
        UpdateApnsChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateApnsChannelResponse.ReadOnly
      ]
  object GetGcmChannel
      extends Effect[
        GetGcmChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetGcmChannelResponse.ReadOnly
      ]
  object DeleteJourney
      extends Effect[
        DeleteJourneyRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly
      ]
  object GetApnsVoipSandboxChannel
      extends Effect[
        GetApnsVoipSandboxChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetApnsVoipSandboxChannelResponse.ReadOnly
      ]
  object PutEvents
      extends Effect[
        PutEventsRequest,
        AwsError,
        zio.aws.pinpoint.model.PutEventsResponse.ReadOnly
      ]
  object DeleteSmsChannel
      extends Effect[
        DeleteSmsChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteSmsChannelResponse.ReadOnly
      ]
  object CreateApp
      extends Effect[
        CreateAppRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateAppResponse.ReadOnly
      ]
  object UpdateRecommenderConfiguration
      extends Effect[
        UpdateRecommenderConfigurationRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateRecommenderConfigurationResponse.ReadOnly
      ]
  object UpdateGcmChannel
      extends Effect[
        UpdateGcmChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateGcmChannelResponse.ReadOnly
      ]
  object DeleteEndpoint
      extends Effect[
        DeleteEndpointRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly
      ]
  object ListTemplates
      extends Effect[
        ListTemplatesRequest,
        AwsError,
        zio.aws.pinpoint.model.ListTemplatesResponse.ReadOnly
      ]
  object UpdatePushTemplate
      extends Effect[
        UpdatePushTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly
      ]
  object UpdateVoiceChannel
      extends Effect[
        UpdateVoiceChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateVoiceChannelResponse.ReadOnly
      ]
  object ListTemplateVersions
      extends Effect[
        ListTemplateVersionsRequest,
        AwsError,
        zio.aws.pinpoint.model.ListTemplateVersionsResponse.ReadOnly
      ]
  object UpdateJourney
      extends Effect[
        UpdateJourneyRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly
      ]
  object DeleteSmsTemplate
      extends Effect[
        DeleteSmsTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly
      ]
  object CreateInAppTemplate
      extends Effect[
        CreateInAppTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateInAppTemplateResponse.ReadOnly
      ]
  object GetInAppTemplate
      extends Effect[
        GetInAppTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.GetInAppTemplateResponse.ReadOnly
      ]
  object GetSegmentExportJobs
      extends Effect[
        GetSegmentExportJobsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSegmentExportJobsResponse.ReadOnly
      ]
  object GetSegment
      extends Effect[
        GetSegmentRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly
      ]
  object CreateImportJob
      extends Effect[
        CreateImportJobRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateImportJobResponse.ReadOnly
      ]
  object DeleteApp
      extends Effect[
        DeleteAppRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly
      ]
  object CreateExportJob
      extends Effect[CreateExportJobRequest, AwsError, ReadOnly]
  object UpdateApnsVoipSandboxChannel
      extends Effect[
        UpdateApnsVoipSandboxChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelResponse.ReadOnly
      ]
  object CreateRecommenderConfiguration
      extends Effect[
        CreateRecommenderConfigurationRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateRecommenderConfigurationResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object UpdateSmsTemplate
      extends Effect[
        UpdateSmsTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateSmsTemplateResponse.ReadOnly
      ]
  object GetCampaignActivities
      extends Effect[
        GetCampaignActivitiesRequest,
        AwsError,
        zio.aws.pinpoint.model.GetCampaignActivitiesResponse.ReadOnly
      ]
  object GetApnsSandboxChannel
      extends Effect[
        GetApnsSandboxChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetApnsSandboxChannelResponse.ReadOnly
      ]
  object UpdateAdmChannel
      extends Effect[
        UpdateAdmChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateAdmChannelResponse.ReadOnly
      ]
  object DeleteEmailTemplate
      extends Effect[
        DeleteEmailTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteEmailTemplateResponse.ReadOnly
      ]
  object GetVoiceTemplate
      extends Effect[
        GetVoiceTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.GetVoiceTemplateResponse.ReadOnly
      ]
  object DeleteVoiceChannel
      extends Effect[
        DeleteVoiceChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteVoiceChannelResponse.ReadOnly
      ]
  object GetApnsVoipChannel
      extends Effect[
        GetApnsVoipChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetApnsVoipChannelResponse.ReadOnly
      ]
  object CreateSegment
      extends Effect[
        CreateSegmentRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly
      ]
  object DeleteEmailChannel
      extends Effect[
        DeleteEmailChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly
      ]
  object GetJourneyExecutionMetrics
      extends Effect[
        GetJourneyExecutionMetricsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetJourneyExecutionMetricsResponse.ReadOnly
      ]
  object UpdateTemplateActiveVersion
      extends Effect[
        UpdateTemplateActiveVersionRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly
      ]
  object GetJourneyDateRangeKpi
      extends Effect[
        GetJourneyDateRangeKpiRequest,
        AwsError,
        zio.aws.pinpoint.model.GetJourneyDateRangeKpiResponse.ReadOnly
      ]
  object GetJourney
      extends Effect[
        GetJourneyRequest,
        AwsError,
        zio.aws.pinpoint.model.GetJourneyResponse.ReadOnly
      ]
  object UpdateVoiceTemplate
      extends Effect[
        UpdateVoiceTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateVoiceTemplateResponse.ReadOnly
      ]
  object DeleteApnsVoipSandboxChannel
      extends Effect[
        DeleteApnsVoipSandboxChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelResponse.ReadOnly
      ]
  object GetApplicationDateRangeKpi
      extends Effect[
        GetApplicationDateRangeKpiRequest,
        AwsError,
        zio.aws.pinpoint.model.GetApplicationDateRangeKpiResponse.ReadOnly
      ]
  object CreateCampaign
      extends Effect[
        CreateCampaignRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateCampaignResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetSegments
      extends Effect[
        GetSegmentsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSegmentsResponse.ReadOnly
      ]
  object UpdateEmailTemplate
      extends Effect[
        UpdateEmailTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly
      ]
  object GetExportJobs
      extends Effect[
        GetExportJobsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetExportJobsResponse.ReadOnly
      ]
  object UpdateJourneyState
      extends Effect[
        UpdateJourneyStateRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object GetSmsChannel
      extends Effect[
        GetSmsChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSmsChannelResponse.ReadOnly
      ]
  object DeleteInAppTemplate
      extends Effect[
        DeleteInAppTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteInAppTemplateResponse.ReadOnly
      ]
  object DeleteRecommenderConfiguration
      extends Effect[
        DeleteRecommenderConfigurationRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteRecommenderConfigurationResponse.ReadOnly
      ]
  object UpdateEndpoint
      extends Effect[
        UpdateEndpointRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateEndpointResponse.ReadOnly
      ]
  object DeleteApnsChannel
      extends Effect[
        DeleteApnsChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteApnsChannelResponse.ReadOnly
      ]
  object DeleteApnsVoipChannel
      extends Effect[
        DeleteApnsVoipChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteApnsVoipChannelResponse.ReadOnly
      ]
  object DeletePushTemplate
      extends Effect[
        DeletePushTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.DeletePushTemplateResponse.ReadOnly
      ]
  object UpdateApnsVoipChannel
      extends Effect[
        UpdateApnsVoipChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateApnsVoipChannelResponse.ReadOnly
      ]
  object GetPushTemplate
      extends Effect[
        GetPushTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.GetPushTemplateResponse.ReadOnly
      ]
  object GetImportJob
      extends Effect[
        GetImportJobRequest,
        AwsError,
        zio.aws.pinpoint.model.GetImportJobResponse.ReadOnly
      ]
  object GetRecommenderConfiguration
      extends Effect[
        GetRecommenderConfigurationRequest,
        AwsError,
        zio.aws.pinpoint.model.GetRecommenderConfigurationResponse.ReadOnly
      ]
  object SendUsersMessages
      extends Effect[
        SendUsersMessagesRequest,
        AwsError,
        zio.aws.pinpoint.model.SendUsersMessagesResponse.ReadOnly
      ]
  object DeleteUserEndpoints
      extends Effect[
        DeleteUserEndpointsRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteUserEndpointsResponse.ReadOnly
      ]
  object UpdateSmsChannel
      extends Effect[
        UpdateSmsChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateSmsChannelResponse.ReadOnly
      ]
  object GetSegmentVersions
      extends Effect[
        GetSegmentVersionsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetSegmentVersionsResponse.ReadOnly
      ]
  object CreateVoiceTemplate
      extends Effect[
        CreateVoiceTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.CreateVoiceTemplateResponse.ReadOnly
      ]
  object PutEventStream
      extends Effect[
        PutEventStreamRequest,
        AwsError,
        zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly
      ]
  object DeleteBaiduChannel
      extends Effect[
        DeleteBaiduChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteBaiduChannelResponse.ReadOnly
      ]
  object DeleteGcmChannel
      extends Effect[
        DeleteGcmChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteGcmChannelResponse.ReadOnly
      ]
  object VerifyOTPMessage
      extends Effect[
        VerifyOtpMessageRequest,
        AwsError,
        zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly
      ]
  object DeleteVoiceTemplate
      extends Effect[
        DeleteVoiceTemplateRequest,
        AwsError,
        zio.aws.pinpoint.model.DeleteVoiceTemplateResponse.ReadOnly
      ]
  object GetRecommenderConfigurations
      extends Effect[
        GetRecommenderConfigurationsRequest,
        AwsError,
        zio.aws.pinpoint.model.GetRecommenderConfigurationsResponse.ReadOnly
      ]
  object GetBaiduChannel
      extends Effect[
        GetBaiduChannelRequest,
        AwsError,
        zio.aws.pinpoint.model.GetBaiduChannelResponse.ReadOnly
      ]
  object UpdateCampaign
      extends Effect[
        UpdateCampaignRequest,
        AwsError,
        zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Pinpoint] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Pinpoint {
          val api: PinpointAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Pinpoint = this
          def deleteSegment(request: DeleteSegmentRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly
          ] = proxy(DeleteSegment, request)
          def getInAppMessages(request: GetInAppMessagesRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetInAppMessagesResponse.ReadOnly
          ] = proxy(GetInAppMessages, request)
          def getEndpoint(
              request: GetEndpointRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetEndpointResponse.ReadOnly] =
            proxy(GetEndpoint, request)
          def getEventStream(request: GetEventStreamRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly
          ] = proxy(GetEventStream, request)
          def getEmailChannel(request: GetEmailChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly
          ] = proxy(GetEmailChannel, request)
          def updateEndpointsBatch(request: UpdateEndpointsBatchRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly
          ] = proxy(UpdateEndpointsBatch, request)
          def getApps(
              request: GetAppsRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetAppsResponse.ReadOnly] =
            proxy(GetApps, request)
          def sendMessages(request: SendMessagesRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly
          ] = proxy(SendMessages, request)
          def getApplicationSettings(
              request: GetApplicationSettingsRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetApplicationSettingsResponse.ReadOnly
          ] = proxy(GetApplicationSettings, request)
          def getSegmentVersion(request: GetSegmentVersionRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly
          ] = proxy(GetSegmentVersion, request)
          def deleteCampaign(request: DeleteCampaignRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly
          ] = proxy(DeleteCampaign, request)
          def getCampaign(
              request: GetCampaignRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetCampaignResponse.ReadOnly] =
            proxy(GetCampaign, request)
          def getUserEndpoints(request: GetUserEndpointsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetUserEndpointsResponse.ReadOnly
          ] = proxy(GetUserEndpoints, request)
          def getApp(
              request: GetAppRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetAppResponse.ReadOnly] =
            proxy(GetApp, request)
          def getCampaignDateRangeKpi(
              request: GetCampaignDateRangeKpiRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetCampaignDateRangeKpiResponse.ReadOnly
          ] = proxy(GetCampaignDateRangeKpi, request)
          def deleteApnsSandboxChannel(
              request: DeleteApnsSandboxChannelRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteApnsSandboxChannelResponse.ReadOnly
          ] = proxy(DeleteApnsSandboxChannel, request)
          def getAdmChannel(request: GetAdmChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetAdmChannelResponse.ReadOnly
          ] = proxy(GetAdmChannel, request)
          def getJourneyExecutionActivityMetrics(
              request: GetJourneyExecutionActivityMetricsRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsResponse.ReadOnly
          ] = proxy(GetJourneyExecutionActivityMetrics, request)
          def updateApnsSandboxChannel(
              request: UpdateApnsSandboxChannelRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateApnsSandboxChannelResponse.ReadOnly
          ] = proxy(UpdateApnsSandboxChannel, request)
          def getApnsChannel(request: GetApnsChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetApnsChannelResponse.ReadOnly
          ] = proxy(GetApnsChannel, request)
          def getEmailTemplate(request: GetEmailTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetEmailTemplateResponse.ReadOnly
          ] = proxy(GetEmailTemplate, request)
          def listJourneys(request: ListJourneysRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.ListJourneysResponse.ReadOnly
          ] = proxy(ListJourneys, request)
          def sendOTPMessage(request: SendOtpMessageRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.SendOtpMessageResponse.ReadOnly
          ] = proxy(SendOTPMessage, request)
          def createEmailTemplate(request: CreateEmailTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateEmailTemplateResponse.ReadOnly
          ] = proxy(CreateEmailTemplate, request)
          def removeAttributes(request: RemoveAttributesRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly
          ] = proxy(RemoveAttributes, request)
          def createPushTemplate(request: CreatePushTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreatePushTemplateResponse.ReadOnly
          ] = proxy(CreatePushTemplate, request)
          def getCampaignVersion(request: GetCampaignVersionRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetCampaignVersionResponse.ReadOnly
          ] = proxy(GetCampaignVersion, request)
          def updateSegment(request: UpdateSegmentRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateSegmentResponse.ReadOnly
          ] = proxy(UpdateSegment, request)
          def getCampaignVersions(request: GetCampaignVersionsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetCampaignVersionsResponse.ReadOnly
          ] = proxy(GetCampaignVersions, request)
          def updateBaiduChannel(request: UpdateBaiduChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateBaiduChannelResponse.ReadOnly
          ] = proxy(UpdateBaiduChannel, request)
          def createSmsTemplate(request: CreateSmsTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateSmsTemplateResponse.ReadOnly
          ] = proxy(CreateSmsTemplate, request)
          def createJourney(request: CreateJourneyRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateJourneyResponse.ReadOnly
          ] = proxy(CreateJourney, request)
          def getImportJobs(request: GetImportJobsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetImportJobsResponse.ReadOnly
          ] = proxy(GetImportJobs, request)
          def getExportJob(request: GetExportJobRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetExportJobResponse.ReadOnly
          ] = proxy(GetExportJob, request)
          def getCampaigns(request: GetCampaignsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetCampaignsResponse.ReadOnly
          ] = proxy(GetCampaigns, request)
          def updateApplicationSettings(
              request: UpdateApplicationSettingsRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateApplicationSettingsResponse.ReadOnly
          ] = proxy(UpdateApplicationSettings, request)
          def getVoiceChannel(request: GetVoiceChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetVoiceChannelResponse.ReadOnly
          ] = proxy(GetVoiceChannel, request)
          def getSmsTemplate(request: GetSmsTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetSmsTemplateResponse.ReadOnly
          ] = proxy(GetSmsTemplate, request)
          def updateEmailChannel(request: UpdateEmailChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly
          ] = proxy(UpdateEmailChannel, request)
          def getSegmentImportJobs(request: GetSegmentImportJobsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetSegmentImportJobsResponse.ReadOnly
          ] = proxy(GetSegmentImportJobs, request)
          def phoneNumberValidate(request: PhoneNumberValidateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.PhoneNumberValidateResponse.ReadOnly
          ] = proxy(PhoneNumberValidate, request)
          def deleteEventStream(request: DeleteEventStreamRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly
          ] = proxy(DeleteEventStream, request)
          def deleteAdmChannel(request: DeleteAdmChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteAdmChannelResponse.ReadOnly
          ] = proxy(DeleteAdmChannel, request)
          def updateInAppTemplate(request: UpdateInAppTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateInAppTemplateResponse.ReadOnly
          ] = proxy(UpdateInAppTemplate, request)
          def getChannels(
              request: GetChannelsRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetChannelsResponse.ReadOnly] =
            proxy(GetChannels, request)
          def updateApnsChannel(request: UpdateApnsChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateApnsChannelResponse.ReadOnly
          ] = proxy(UpdateApnsChannel, request)
          def getGcmChannel(request: GetGcmChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetGcmChannelResponse.ReadOnly
          ] = proxy(GetGcmChannel, request)
          def deleteJourney(request: DeleteJourneyRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly
          ] = proxy(DeleteJourney, request)
          def getApnsVoipSandboxChannel(
              request: GetApnsVoipSandboxChannelRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetApnsVoipSandboxChannelResponse.ReadOnly
          ] = proxy(GetApnsVoipSandboxChannel, request)
          def putEvents(
              request: PutEventsRequest
          ): IO[AwsError, zio.aws.pinpoint.model.PutEventsResponse.ReadOnly] =
            proxy(PutEvents, request)
          def deleteSmsChannel(request: DeleteSmsChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteSmsChannelResponse.ReadOnly
          ] = proxy(DeleteSmsChannel, request)
          def createApp(
              request: CreateAppRequest
          ): IO[AwsError, zio.aws.pinpoint.model.CreateAppResponse.ReadOnly] =
            proxy(CreateApp, request)
          def updateRecommenderConfiguration(
              request: UpdateRecommenderConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateRecommenderConfigurationResponse.ReadOnly
          ] = proxy(UpdateRecommenderConfiguration, request)
          def updateGcmChannel(request: UpdateGcmChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateGcmChannelResponse.ReadOnly
          ] = proxy(UpdateGcmChannel, request)
          def deleteEndpoint(request: DeleteEndpointRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly
          ] = proxy(DeleteEndpoint, request)
          def listTemplates(request: ListTemplatesRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.ListTemplatesResponse.ReadOnly
          ] = proxy(ListTemplates, request)
          def updatePushTemplate(request: UpdatePushTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdatePushTemplateResponse.ReadOnly
          ] = proxy(UpdatePushTemplate, request)
          def updateVoiceChannel(request: UpdateVoiceChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateVoiceChannelResponse.ReadOnly
          ] = proxy(UpdateVoiceChannel, request)
          def listTemplateVersions(request: ListTemplateVersionsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.ListTemplateVersionsResponse.ReadOnly
          ] = proxy(ListTemplateVersions, request)
          def updateJourney(request: UpdateJourneyRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly
          ] = proxy(UpdateJourney, request)
          def deleteSmsTemplate(request: DeleteSmsTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteSmsTemplateResponse.ReadOnly
          ] = proxy(DeleteSmsTemplate, request)
          def createInAppTemplate(request: CreateInAppTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateInAppTemplateResponse.ReadOnly
          ] = proxy(CreateInAppTemplate, request)
          def getInAppTemplate(request: GetInAppTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetInAppTemplateResponse.ReadOnly
          ] = proxy(GetInAppTemplate, request)
          def getSegmentExportJobs(request: GetSegmentExportJobsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetSegmentExportJobsResponse.ReadOnly
          ] = proxy(GetSegmentExportJobs, request)
          def getSegment(
              request: GetSegmentRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly] =
            proxy(GetSegment, request)
          def createImportJob(request: CreateImportJobRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateImportJobResponse.ReadOnly
          ] = proxy(CreateImportJob, request)
          def deleteApp(
              request: DeleteAppRequest
          ): IO[AwsError, zio.aws.pinpoint.model.DeleteAppResponse.ReadOnly] =
            proxy(DeleteApp, request)
          def createExportJob(
              request: CreateExportJobRequest
          ): IO[AwsError, ReadOnly] = proxy(CreateExportJob, request)
          def updateApnsVoipSandboxChannel(
              request: UpdateApnsVoipSandboxChannelRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelResponse.ReadOnly
          ] = proxy(UpdateApnsVoipSandboxChannel, request)
          def createRecommenderConfiguration(
              request: CreateRecommenderConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateRecommenderConfigurationResponse.ReadOnly
          ] = proxy(CreateRecommenderConfiguration, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def updateSmsTemplate(request: UpdateSmsTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateSmsTemplateResponse.ReadOnly
          ] = proxy(UpdateSmsTemplate, request)
          def getCampaignActivities(request: GetCampaignActivitiesRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetCampaignActivitiesResponse.ReadOnly
          ] = proxy(GetCampaignActivities, request)
          def getApnsSandboxChannel(request: GetApnsSandboxChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetApnsSandboxChannelResponse.ReadOnly
          ] = proxy(GetApnsSandboxChannel, request)
          def updateAdmChannel(request: UpdateAdmChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateAdmChannelResponse.ReadOnly
          ] = proxy(UpdateAdmChannel, request)
          def deleteEmailTemplate(request: DeleteEmailTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteEmailTemplateResponse.ReadOnly
          ] = proxy(DeleteEmailTemplate, request)
          def getVoiceTemplate(request: GetVoiceTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetVoiceTemplateResponse.ReadOnly
          ] = proxy(GetVoiceTemplate, request)
          def deleteVoiceChannel(request: DeleteVoiceChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteVoiceChannelResponse.ReadOnly
          ] = proxy(DeleteVoiceChannel, request)
          def getApnsVoipChannel(request: GetApnsVoipChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetApnsVoipChannelResponse.ReadOnly
          ] = proxy(GetApnsVoipChannel, request)
          def createSegment(request: CreateSegmentRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly
          ] = proxy(CreateSegment, request)
          def deleteEmailChannel(request: DeleteEmailChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteEmailChannelResponse.ReadOnly
          ] = proxy(DeleteEmailChannel, request)
          def getJourneyExecutionMetrics(
              request: GetJourneyExecutionMetricsRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetJourneyExecutionMetricsResponse.ReadOnly
          ] = proxy(GetJourneyExecutionMetrics, request)
          def updateTemplateActiveVersion(
              request: UpdateTemplateActiveVersionRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly
          ] = proxy(UpdateTemplateActiveVersion, request)
          def getJourneyDateRangeKpi(
              request: GetJourneyDateRangeKpiRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetJourneyDateRangeKpiResponse.ReadOnly
          ] = proxy(GetJourneyDateRangeKpi, request)
          def getJourney(
              request: GetJourneyRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetJourneyResponse.ReadOnly] =
            proxy(GetJourney, request)
          def updateVoiceTemplate(request: UpdateVoiceTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateVoiceTemplateResponse.ReadOnly
          ] = proxy(UpdateVoiceTemplate, request)
          def deleteApnsVoipSandboxChannel(
              request: DeleteApnsVoipSandboxChannelRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteApnsVoipSandboxChannelResponse.ReadOnly
          ] = proxy(DeleteApnsVoipSandboxChannel, request)
          def getApplicationDateRangeKpi(
              request: GetApplicationDateRangeKpiRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetApplicationDateRangeKpiResponse.ReadOnly
          ] = proxy(GetApplicationDateRangeKpi, request)
          def createCampaign(request: CreateCampaignRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateCampaignResponse.ReadOnly
          ] = proxy(CreateCampaign, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def getSegments(
              request: GetSegmentsRequest
          ): IO[AwsError, zio.aws.pinpoint.model.GetSegmentsResponse.ReadOnly] =
            proxy(GetSegments, request)
          def updateEmailTemplate(request: UpdateEmailTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly
          ] = proxy(UpdateEmailTemplate, request)
          def getExportJobs(request: GetExportJobsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetExportJobsResponse.ReadOnly
          ] = proxy(GetExportJobs, request)
          def updateJourneyState(request: UpdateJourneyStateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly
          ] = proxy(UpdateJourneyState, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def getSmsChannel(request: GetSmsChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetSmsChannelResponse.ReadOnly
          ] = proxy(GetSmsChannel, request)
          def deleteInAppTemplate(request: DeleteInAppTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteInAppTemplateResponse.ReadOnly
          ] = proxy(DeleteInAppTemplate, request)
          def deleteRecommenderConfiguration(
              request: DeleteRecommenderConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteRecommenderConfigurationResponse.ReadOnly
          ] = proxy(DeleteRecommenderConfiguration, request)
          def updateEndpoint(request: UpdateEndpointRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateEndpointResponse.ReadOnly
          ] = proxy(UpdateEndpoint, request)
          def deleteApnsChannel(request: DeleteApnsChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteApnsChannelResponse.ReadOnly
          ] = proxy(DeleteApnsChannel, request)
          def deleteApnsVoipChannel(request: DeleteApnsVoipChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteApnsVoipChannelResponse.ReadOnly
          ] = proxy(DeleteApnsVoipChannel, request)
          def deletePushTemplate(request: DeletePushTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeletePushTemplateResponse.ReadOnly
          ] = proxy(DeletePushTemplate, request)
          def updateApnsVoipChannel(request: UpdateApnsVoipChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateApnsVoipChannelResponse.ReadOnly
          ] = proxy(UpdateApnsVoipChannel, request)
          def getPushTemplate(request: GetPushTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetPushTemplateResponse.ReadOnly
          ] = proxy(GetPushTemplate, request)
          def getImportJob(request: GetImportJobRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetImportJobResponse.ReadOnly
          ] = proxy(GetImportJob, request)
          def getRecommenderConfiguration(
              request: GetRecommenderConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetRecommenderConfigurationResponse.ReadOnly
          ] = proxy(GetRecommenderConfiguration, request)
          def sendUsersMessages(request: SendUsersMessagesRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.SendUsersMessagesResponse.ReadOnly
          ] = proxy(SendUsersMessages, request)
          def deleteUserEndpoints(request: DeleteUserEndpointsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteUserEndpointsResponse.ReadOnly
          ] = proxy(DeleteUserEndpoints, request)
          def updateSmsChannel(request: UpdateSmsChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateSmsChannelResponse.ReadOnly
          ] = proxy(UpdateSmsChannel, request)
          def getSegmentVersions(request: GetSegmentVersionsRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetSegmentVersionsResponse.ReadOnly
          ] = proxy(GetSegmentVersions, request)
          def createVoiceTemplate(request: CreateVoiceTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.CreateVoiceTemplateResponse.ReadOnly
          ] = proxy(CreateVoiceTemplate, request)
          def putEventStream(request: PutEventStreamRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly
          ] = proxy(PutEventStream, request)
          def deleteBaiduChannel(request: DeleteBaiduChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteBaiduChannelResponse.ReadOnly
          ] = proxy(DeleteBaiduChannel, request)
          def deleteGcmChannel(request: DeleteGcmChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteGcmChannelResponse.ReadOnly
          ] = proxy(DeleteGcmChannel, request)
          def verifyOTPMessage(request: VerifyOtpMessageRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly
          ] = proxy(VerifyOTPMessage, request)
          def deleteVoiceTemplate(request: DeleteVoiceTemplateRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.DeleteVoiceTemplateResponse.ReadOnly
          ] = proxy(DeleteVoiceTemplate, request)
          def getRecommenderConfigurations(
              request: GetRecommenderConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.pinpoint.model.GetRecommenderConfigurationsResponse.ReadOnly
          ] = proxy(GetRecommenderConfigurations, request)
          def getBaiduChannel(request: GetBaiduChannelRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.GetBaiduChannelResponse.ReadOnly
          ] = proxy(GetBaiduChannel, request)
          def updateCampaign(request: UpdateCampaignRequest): IO[
            AwsError,
            zio.aws.pinpoint.model.UpdateCampaignResponse.ReadOnly
          ] = proxy(UpdateCampaign, request)
        }
      }
    }
    .toLayer
}
