package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class APNSChannelRequest(
    bundleId: Option[__string] = None,
    certificate: Option[__string] = None,
    defaultAuthenticationMethod: Option[__string] = None,
    enabled: Option[__boolean] = None,
    privateKey: Option[__string] = None,
    teamId: Option[__string] = None,
    tokenKey: Option[__string] = None,
    tokenKeyId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest = {
    import APNSChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
      .builder()
      .optionallyWith(
        bundleId.map(value => __string.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        certificate.map(value => __string.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(
        defaultAuthenticationMethod.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultAuthenticationMethod)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        privateKey.map(value => __string.unwrap(value): java.lang.String)
      )(_.privateKey)
      .optionallyWith(
        teamId.map(value => __string.unwrap(value): java.lang.String)
      )(_.teamId)
      .optionallyWith(
        tokenKey.map(value => __string.unwrap(value): java.lang.String)
      )(_.tokenKey)
      .optionallyWith(
        tokenKeyId.map(value => __string.unwrap(value): java.lang.String)
      )(_.tokenKeyId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.APNSChannelRequest.wrap(buildAwsValue())
}
object APNSChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.APNSChannelRequest =
      zio.aws.pinpoint.model.APNSChannelRequest(
        bundleId.map(value => value),
        certificate.map(value => value),
        defaultAuthenticationMethod.map(value => value),
        enabled.map(value => value),
        privateKey.map(value => value),
        teamId.map(value => value),
        tokenKey.map(value => value),
        tokenKeyId.map(value => value)
      )
    def bundleId: Option[__string]
    def certificate: Option[__string]
    def defaultAuthenticationMethod: Option[__string]
    def enabled: Option[__boolean]
    def privateKey: Option[__string]
    def teamId: Option[__string]
    def tokenKey: Option[__string]
    def tokenKeyId: Option[__string]
    def getBundleId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCertificate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getDefaultAuthenticationMethod: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "defaultAuthenticationMethod",
        defaultAuthenticationMethod
      )
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getPrivateKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getTeamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("teamId", teamId)
    def getTokenKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("tokenKey", tokenKey)
    def getTokenKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("tokenKeyId", tokenKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
  ) extends zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly {
    override val bundleId: Option[__string] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val certificate: Option[__string] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val defaultAuthenticationMethod: Option[__string] = scala
      .Option(impl.defaultAuthenticationMethod())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val privateKey: Option[__string] = scala
      .Option(impl.privateKey())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val teamId: Option[__string] = scala
      .Option(impl.teamId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tokenKey: Option[__string] = scala
      .Option(impl.tokenKey())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tokenKeyId: Option[__string] = scala
      .Option(impl.tokenKeyId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest
  ): zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly = new Wrapper(impl)
}
