package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __integer, __string}
import scala.jdk.CollectionConverters.*
final case class APNSMessage(
    apnsPushType: Option[__string] = None,
    action: Option[zio.aws.pinpoint.model.Action] = None,
    badge: Option[__integer] = None,
    body: Option[__string] = None,
    category: Option[__string] = None,
    collapseId: Option[__string] = None,
    data: Option[Map[__string, __string]] = None,
    mediaUrl: Option[__string] = None,
    preferredAuthenticationMethod: Option[__string] = None,
    priority: Option[__string] = None,
    rawContent: Option[__string] = None,
    silentPush: Option[__boolean] = None,
    sound: Option[__string] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    threadId: Option[__string] = None,
    timeToLive: Option[__integer] = None,
    title: Option[__string] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.APNSMessage = {
    import APNSMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.APNSMessage
      .builder()
      .optionallyWith(
        apnsPushType.map(value => __string.unwrap(value): java.lang.String)
      )(_.apnsPushType)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(badge.map(value => __integer.unwrap(value): Integer))(
        _.badge
      )
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        category.map(value => __string.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        collapseId.map(value => __string.unwrap(value): java.lang.String)
      )(_.collapseId)
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.data)
      .optionallyWith(
        mediaUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.mediaUrl)
      .optionallyWith(
        preferredAuthenticationMethod.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.preferredAuthenticationMethod)
      .optionallyWith(
        priority.map(value => __string.unwrap(value): java.lang.String)
      )(_.priority)
      .optionallyWith(
        rawContent.map(value => __string.unwrap(value): java.lang.String)
      )(_.rawContent)
      .optionallyWith(
        silentPush.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.silentPush)
      .optionallyWith(
        sound.map(value => __string.unwrap(value): java.lang.String)
      )(_.sound)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        threadId.map(value => __string.unwrap(value): java.lang.String)
      )(_.threadId)
      .optionallyWith(
        timeToLive.map(value => __integer.unwrap(value): Integer)
      )(_.timeToLive)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.APNSMessage.ReadOnly =
    zio.aws.pinpoint.model.APNSMessage.wrap(buildAwsValue())
}
object APNSMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.APNSMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.APNSMessage =
      zio.aws.pinpoint.model.APNSMessage(
        apnsPushType.map(value => value),
        action.map(value => value),
        badge.map(value => value),
        body.map(value => value),
        category.map(value => value),
        collapseId.map(value => value),
        data.map(value => value),
        mediaUrl.map(value => value),
        preferredAuthenticationMethod.map(value => value),
        priority.map(value => value),
        rawContent.map(value => value),
        silentPush.map(value => value),
        sound.map(value => value),
        substitutions.map(value => value),
        threadId.map(value => value),
        timeToLive.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def apnsPushType: Option[__string]
    def action: Option[zio.aws.pinpoint.model.Action]
    def badge: Option[__integer]
    def body: Option[__string]
    def category: Option[__string]
    def collapseId: Option[__string]
    def data: Option[Map[__string, __string]]
    def mediaUrl: Option[__string]
    def preferredAuthenticationMethod: Option[__string]
    def priority: Option[__string]
    def rawContent: Option[__string]
    def silentPush: Option[__boolean]
    def sound: Option[__string]
    def substitutions: Option[Map[__string, List[__string]]]
    def threadId: Option[__string]
    def timeToLive: Option[__integer]
    def title: Option[__string]
    def url: Option[__string]
    def getApnsPushType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apnsPushType", apnsPushType)
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBadge: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("badge", badge)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getCategory: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("category", category)
    def getCollapseId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("collapseId", collapseId)
    def getData: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("data", data)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getPreferredAuthenticationMethod: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "preferredAuthenticationMethod",
        preferredAuthenticationMethod
      )
    def getPriority: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("priority", priority)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getSound: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sound", sound)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getThreadId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("threadId", threadId)
    def getTimeToLive: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSMessage
  ) extends zio.aws.pinpoint.model.APNSMessage.ReadOnly {
    override val apnsPushType: Option[__string] = scala
      .Option(impl.apnsPushType())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val action: Option[zio.aws.pinpoint.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val badge: Option[__integer] = scala
      .Option(impl.badge())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val category: Option[__string] = scala
      .Option(impl.category())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val collapseId: Option[__string] = scala
      .Option(impl.collapseId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val data: Option[Map[__string, __string]] = scala
      .Option(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val mediaUrl: Option[__string] = scala
      .Option(impl.mediaUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val preferredAuthenticationMethod: Option[__string] = scala
      .Option(impl.preferredAuthenticationMethod())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val priority: Option[__string] = scala
      .Option(impl.priority())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val rawContent: Option[__string] = scala
      .Option(impl.rawContent())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val silentPush: Option[__boolean] = scala
      .Option(impl.silentPush())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val sound: Option[__string] = scala
      .Option(impl.sound())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val threadId: Option[__string] = scala
      .Option(impl.threadId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val timeToLive: Option[__integer] = scala
      .Option(impl.timeToLive())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSMessage
  ): zio.aws.pinpoint.model.APNSMessage.ReadOnly = new Wrapper(impl)
}
