package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class APNSPushNotificationTemplate(
    action: Option[zio.aws.pinpoint.model.Action] = None,
    body: Option[__string] = None,
    mediaUrl: Option[__string] = None,
    rawContent: Option[__string] = None,
    sound: Option[__string] = None,
    title: Option[__string] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate = {
    import APNSPushNotificationTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        mediaUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.mediaUrl)
      .optionallyWith(
        rawContent.map(value => __string.unwrap(value): java.lang.String)
      )(_.rawContent)
      .optionallyWith(
        sound.map(value => __string.unwrap(value): java.lang.String)
      )(_.sound)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly =
    zio.aws.pinpoint.model.APNSPushNotificationTemplate.wrap(buildAwsValue())
}
object APNSPushNotificationTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.APNSPushNotificationTemplate =
      zio.aws.pinpoint.model.APNSPushNotificationTemplate(
        action.map(value => value),
        body.map(value => value),
        mediaUrl.map(value => value),
        rawContent.map(value => value),
        sound.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Option[zio.aws.pinpoint.model.Action]
    def body: Option[__string]
    def mediaUrl: Option[__string]
    def rawContent: Option[__string]
    def sound: Option[__string]
    def title: Option[__string]
    def url: Option[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSound: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sound", sound)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate
  ) extends zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly {
    override val action: Option[zio.aws.pinpoint.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val mediaUrl: Option[__string] = scala
      .Option(impl.mediaUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val rawContent: Option[__string] = scala
      .Option(impl.rawContent())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val sound: Option[__string] = scala
      .Option(impl.sound())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSPushNotificationTemplate
  ): zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly = new Wrapper(
    impl
  )
}
