package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import scala.jdk.CollectionConverters.*
final case class APNSVoipSandboxChannelResponse(
    applicationId: Option[__string] = None,
    creationDate: Option[__string] = None,
    defaultAuthenticationMethod: Option[__string] = None,
    enabled: Option[__boolean] = None,
    hasCredential: Option[__boolean] = None,
    hasTokenKey: Option[__boolean] = None,
    id: Option[__string] = None,
    isArchived: Option[__boolean] = None,
    lastModifiedBy: Option[__string] = None,
    lastModifiedDate: Option[__string] = None,
    platform: __string,
    version: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.APNSVoipSandboxChannelResponse = {
    import APNSVoipSandboxChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.APNSVoipSandboxChannelResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        creationDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationDate)
      .optionallyWith(
        defaultAuthenticationMethod.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultAuthenticationMethod)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        hasCredential.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.hasCredential)
      .optionallyWith(
        hasTokenKey.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.hasTokenKey)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        isArchived.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.isArchived)
      .optionallyWith(
        lastModifiedBy.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .platform(__string.unwrap(platform): java.lang.String)
      .optionallyWith(version.map(value => __integer.unwrap(value): Integer))(
        _.version
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.APNSVoipSandboxChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.APNSVoipSandboxChannelResponse.wrap(buildAwsValue())
}
object APNSVoipSandboxChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.APNSVoipSandboxChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.APNSVoipSandboxChannelResponse =
      zio.aws.pinpoint.model.APNSVoipSandboxChannelResponse(
        applicationId.map(value => value),
        creationDate.map(value => value),
        defaultAuthenticationMethod.map(value => value),
        enabled.map(value => value),
        hasCredential.map(value => value),
        hasTokenKey.map(value => value),
        id.map(value => value),
        isArchived.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        platform,
        version.map(value => value)
      )
    def applicationId: Option[__string]
    def creationDate: Option[__string]
    def defaultAuthenticationMethod: Option[__string]
    def enabled: Option[__boolean]
    def hasCredential: Option[__boolean]
    def hasTokenKey: Option[__boolean]
    def id: Option[__string]
    def isArchived: Option[__boolean]
    def lastModifiedBy: Option[__string]
    def lastModifiedDate: Option[__string]
    def platform: __string
    def version: Option[__integer]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDefaultAuthenticationMethod: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "defaultAuthenticationMethod",
        defaultAuthenticationMethod
      )
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getHasCredential: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("hasCredential", hasCredential)
    def getHasTokenKey: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("hasTokenKey", hasTokenKey)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIsArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getPlatform: ZIO[Any, Nothing, __string] = ZIO.succeed(platform)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSVoipSandboxChannelResponse
  ) extends zio.aws.pinpoint.model.APNSVoipSandboxChannelResponse.ReadOnly {
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: Option[__string] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val defaultAuthenticationMethod: Option[__string] = scala
      .Option(impl.defaultAuthenticationMethod())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val hasCredential: Option[__boolean] = scala
      .Option(impl.hasCredential())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val hasTokenKey: Option[__boolean] = scala
      .Option(impl.hasTokenKey())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val isArchived: Option[__boolean] = scala
      .Option(impl.isArchived())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val lastModifiedBy: Option[__string] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val platform: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.platform())
    override val version: Option[__integer] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.APNSVoipSandboxChannelResponse
  ): zio.aws.pinpoint.model.APNSVoipSandboxChannelResponse.ReadOnly =
    new Wrapper(impl)
}
