package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ActivitiesResponse(
    item: Iterable[zio.aws.pinpoint.model.ActivityResponse],
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ActivitiesResponse = {
    import ActivitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ActivitiesResponse
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ActivitiesResponse.ReadOnly =
    zio.aws.pinpoint.model.ActivitiesResponse.wrap(buildAwsValue())
}
object ActivitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ActivitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ActivitiesResponse =
      zio.aws.pinpoint.model.ActivitiesResponse(
        item.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def item: List[zio.aws.pinpoint.model.ActivityResponse.ReadOnly]
    def nextToken: Option[__string]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.ActivityResponse.ReadOnly
    ]] = ZIO.succeed(item)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ActivitiesResponse
  ) extends zio.aws.pinpoint.model.ActivitiesResponse.ReadOnly {
    override val item: List[zio.aws.pinpoint.model.ActivityResponse.ReadOnly] =
      impl
        .item()
        .asScala
        .map { item =>
          zio.aws.pinpoint.model.ActivityResponse.wrap(item)
        }
        .toList
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ActivitiesResponse
  ): zio.aws.pinpoint.model.ActivitiesResponse.ReadOnly = new Wrapper(impl)
}
