package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class Activity(
    custom: Option[zio.aws.pinpoint.model.CustomMessageActivity] = None,
    conditionalSplit: Option[zio.aws.pinpoint.model.ConditionalSplitActivity] =
      None,
    description: Option[__string] = None,
    email: Option[zio.aws.pinpoint.model.EmailMessageActivity] = None,
    holdout: Option[zio.aws.pinpoint.model.HoldoutActivity] = None,
    multiCondition: Option[
      zio.aws.pinpoint.model.MultiConditionalSplitActivity
    ] = None,
    push: Option[zio.aws.pinpoint.model.PushMessageActivity] = None,
    randomSplit: Option[zio.aws.pinpoint.model.RandomSplitActivity] = None,
    sms: Option[zio.aws.pinpoint.model.SMSMessageActivity] = None,
    waitValue: Option[zio.aws.pinpoint.model.WaitActivity] = None,
    contactCenter: Option[zio.aws.pinpoint.model.ContactCenterActivity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Activity = {
    import Activity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Activity
      .builder()
      .optionallyWith(custom.map(value => value.buildAwsValue()))(_.custom)
      .optionallyWith(conditionalSplit.map(value => value.buildAwsValue()))(
        _.conditionalSplit
      )
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(email.map(value => value.buildAwsValue()))(_.email)
      .optionallyWith(holdout.map(value => value.buildAwsValue()))(_.holdout)
      .optionallyWith(multiCondition.map(value => value.buildAwsValue()))(
        _.multiCondition
      )
      .optionallyWith(push.map(value => value.buildAwsValue()))(_.push)
      .optionallyWith(randomSplit.map(value => value.buildAwsValue()))(
        _.randomSplit
      )
      .optionallyWith(sms.map(value => value.buildAwsValue()))(_.sms)
      .optionallyWith(waitValue.map(value => value.buildAwsValue()))(
        _.waitValue
      )
      .optionallyWith(contactCenter.map(value => value.buildAwsValue()))(
        _.contactCenter
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Activity.ReadOnly =
    zio.aws.pinpoint.model.Activity.wrap(buildAwsValue())
}
object Activity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Activity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Activity =
      zio.aws.pinpoint.model.Activity(
        custom.map(value => value.asEditable),
        conditionalSplit.map(value => value.asEditable),
        description.map(value => value),
        email.map(value => value.asEditable),
        holdout.map(value => value.asEditable),
        multiCondition.map(value => value.asEditable),
        push.map(value => value.asEditable),
        randomSplit.map(value => value.asEditable),
        sms.map(value => value.asEditable),
        waitValue.map(value => value.asEditable),
        contactCenter.map(value => value.asEditable)
      )
    def custom: Option[zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly]
    def conditionalSplit
        : Option[zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly]
    def description: Option[__string]
    def email: Option[zio.aws.pinpoint.model.EmailMessageActivity.ReadOnly]
    def holdout: Option[zio.aws.pinpoint.model.HoldoutActivity.ReadOnly]
    def multiCondition
        : Option[zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly]
    def push: Option[zio.aws.pinpoint.model.PushMessageActivity.ReadOnly]
    def randomSplit: Option[zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly]
    def sms: Option[zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly]
    def waitValue: Option[zio.aws.pinpoint.model.WaitActivity.ReadOnly]
    def contactCenter
        : Option[zio.aws.pinpoint.model.ContactCenterActivity.ReadOnly]
    def getCustom: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("custom", custom)
    def getConditionalSplit: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly
    ] = AwsError.unwrapOptionField("conditionalSplit", conditionalSplit)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getEmail: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EmailMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("email", email)
    def getHoldout
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.HoldoutActivity.ReadOnly] =
      AwsError.unwrapOptionField("holdout", holdout)
    def getMultiCondition: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly
    ] = AwsError.unwrapOptionField("multiCondition", multiCondition)
    def getPush: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.PushMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("push", push)
    def getRandomSplit: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly
    ] = AwsError.unwrapOptionField("randomSplit", randomSplit)
    def getSms: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("sms", sms)
    def getWaitValue
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.WaitActivity.ReadOnly] =
      AwsError.unwrapOptionField("waitValue", waitValue)
    def getContactCenter: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.ContactCenterActivity.ReadOnly
    ] = AwsError.unwrapOptionField("contactCenter", contactCenter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Activity
  ) extends zio.aws.pinpoint.model.Activity.ReadOnly {
    override val custom
        : Option[zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly] = scala
      .Option(impl.custom())
      .map(value => zio.aws.pinpoint.model.CustomMessageActivity.wrap(value))
    override val conditionalSplit
        : Option[zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly] =
      scala
        .Option(impl.conditionalSplit())
        .map(value =>
          zio.aws.pinpoint.model.ConditionalSplitActivity.wrap(value)
        )
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val email
        : Option[zio.aws.pinpoint.model.EmailMessageActivity.ReadOnly] = scala
      .Option(impl.email())
      .map(value => zio.aws.pinpoint.model.EmailMessageActivity.wrap(value))
    override val holdout
        : Option[zio.aws.pinpoint.model.HoldoutActivity.ReadOnly] = scala
      .Option(impl.holdout())
      .map(value => zio.aws.pinpoint.model.HoldoutActivity.wrap(value))
    override val multiCondition: Option[
      zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly
    ] = scala
      .Option(impl.multiCondition())
      .map(value =>
        zio.aws.pinpoint.model.MultiConditionalSplitActivity.wrap(value)
      )
    override val push
        : Option[zio.aws.pinpoint.model.PushMessageActivity.ReadOnly] = scala
      .Option(impl.push())
      .map(value => zio.aws.pinpoint.model.PushMessageActivity.wrap(value))
    override val randomSplit
        : Option[zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly] = scala
      .Option(impl.randomSplit())
      .map(value => zio.aws.pinpoint.model.RandomSplitActivity.wrap(value))
    override val sms
        : Option[zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly] = scala
      .Option(impl.sms())
      .map(value => zio.aws.pinpoint.model.SMSMessageActivity.wrap(value))
    override val waitValue
        : Option[zio.aws.pinpoint.model.WaitActivity.ReadOnly] = scala
      .Option(impl.waitValue())
      .map(value => zio.aws.pinpoint.model.WaitActivity.wrap(value))
    override val contactCenter
        : Option[zio.aws.pinpoint.model.ContactCenterActivity.ReadOnly] = scala
      .Option(impl.contactCenter())
      .map(value => zio.aws.pinpoint.model.ContactCenterActivity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Activity
  ): zio.aws.pinpoint.model.Activity.ReadOnly = new Wrapper(impl)
}
