package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class ActivityResponse(
    applicationId: __string,
    campaignId: __string,
    end: Option[__string] = None,
    id: __string,
    result: Option[__string] = None,
    scheduledStart: Option[__string] = None,
    start: Option[__string] = None,
    state: Option[__string] = None,
    successfulEndpointCount: Option[__integer] = None,
    timezonesCompletedCount: Option[__integer] = None,
    timezonesTotalCount: Option[__integer] = None,
    totalEndpointCount: Option[__integer] = None,
    treatmentId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ActivityResponse = {
    import ActivityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ActivityResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .campaignId(__string.unwrap(campaignId): java.lang.String)
      .optionallyWith(
        end.map(value => __string.unwrap(value): java.lang.String)
      )(_.end)
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(
        result.map(value => __string.unwrap(value): java.lang.String)
      )(_.result)
      .optionallyWith(
        scheduledStart.map(value => __string.unwrap(value): java.lang.String)
      )(_.scheduledStart)
      .optionallyWith(
        start.map(value => __string.unwrap(value): java.lang.String)
      )(_.start)
      .optionallyWith(
        state.map(value => __string.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        successfulEndpointCount.map(value => __integer.unwrap(value): Integer)
      )(_.successfulEndpointCount)
      .optionallyWith(
        timezonesCompletedCount.map(value => __integer.unwrap(value): Integer)
      )(_.timezonesCompletedCount)
      .optionallyWith(
        timezonesTotalCount.map(value => __integer.unwrap(value): Integer)
      )(_.timezonesTotalCount)
      .optionallyWith(
        totalEndpointCount.map(value => __integer.unwrap(value): Integer)
      )(_.totalEndpointCount)
      .optionallyWith(
        treatmentId.map(value => __string.unwrap(value): java.lang.String)
      )(_.treatmentId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ActivityResponse.ReadOnly =
    zio.aws.pinpoint.model.ActivityResponse.wrap(buildAwsValue())
}
object ActivityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ActivityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ActivityResponse =
      zio.aws.pinpoint.model.ActivityResponse(
        applicationId,
        campaignId,
        end.map(value => value),
        id,
        result.map(value => value),
        scheduledStart.map(value => value),
        start.map(value => value),
        state.map(value => value),
        successfulEndpointCount.map(value => value),
        timezonesCompletedCount.map(value => value),
        timezonesTotalCount.map(value => value),
        totalEndpointCount.map(value => value),
        treatmentId.map(value => value)
      )
    def applicationId: __string
    def campaignId: __string
    def end: Option[__string]
    def id: __string
    def result: Option[__string]
    def scheduledStart: Option[__string]
    def start: Option[__string]
    def state: Option[__string]
    def successfulEndpointCount: Option[__integer]
    def timezonesCompletedCount: Option[__integer]
    def timezonesTotalCount: Option[__integer]
    def totalEndpointCount: Option[__integer]
    def treatmentId: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignId: ZIO[Any, Nothing, __string] = ZIO.succeed(campaignId)
    def getEnd: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("end", end)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getResult: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("result", result)
    def getScheduledStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("scheduledStart", scheduledStart)
    def getStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("state", state)
    def getSuccessfulEndpointCount: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("successfulEndpointCount", successfulEndpointCount)
    def getTimezonesCompletedCount: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("timezonesCompletedCount", timezonesCompletedCount)
    def getTimezonesTotalCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timezonesTotalCount", timezonesTotalCount)
    def getTotalEndpointCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalEndpointCount", totalEndpointCount)
    def getTreatmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentId", treatmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ActivityResponse
  ) extends zio.aws.pinpoint.model.ActivityResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val campaignId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.campaignId())
    override val end: Option[__string] = scala
      .Option(impl.end())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val result: Option[__string] = scala
      .Option(impl.result())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val scheduledStart: Option[__string] = scala
      .Option(impl.scheduledStart())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val start: Option[__string] = scala
      .Option(impl.start())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val state: Option[__string] = scala
      .Option(impl.state())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val successfulEndpointCount: Option[__integer] = scala
      .Option(impl.successfulEndpointCount())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val timezonesCompletedCount: Option[__integer] = scala
      .Option(impl.timezonesCompletedCount())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val timezonesTotalCount: Option[__integer] = scala
      .Option(impl.timezonesTotalCount())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val totalEndpointCount: Option[__integer] = scala
      .Option(impl.totalEndpointCount())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val treatmentId: Option[__string] = scala
      .Option(impl.treatmentId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ActivityResponse
  ): zio.aws.pinpoint.model.ActivityResponse.ReadOnly = new Wrapper(impl)
}
