package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class AddressConfiguration(
    bodyOverride: Option[__string] = None,
    channelType: Option[zio.aws.pinpoint.model.ChannelType] = None,
    context: Option[Map[__string, __string]] = None,
    rawContent: Option[__string] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    titleOverride: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.AddressConfiguration = {
    import AddressConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
      .builder()
      .optionallyWith(
        bodyOverride.map(value => __string.unwrap(value): java.lang.String)
      )(_.bodyOverride)
      .optionallyWith(channelType.map(value => value.unwrap))(_.channelType)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        rawContent.map(value => __string.unwrap(value): java.lang.String)
      )(_.rawContent)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        titleOverride.map(value => __string.unwrap(value): java.lang.String)
      )(_.titleOverride)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.AddressConfiguration.ReadOnly =
    zio.aws.pinpoint.model.AddressConfiguration.wrap(buildAwsValue())
}
object AddressConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.AddressConfiguration =
      zio.aws.pinpoint.model.AddressConfiguration(
        bodyOverride.map(value => value),
        channelType.map(value => value),
        context.map(value => value),
        rawContent.map(value => value),
        substitutions.map(value => value),
        titleOverride.map(value => value)
      )
    def bodyOverride: Option[__string]
    def channelType: Option[zio.aws.pinpoint.model.ChannelType]
    def context: Option[Map[__string, __string]]
    def rawContent: Option[__string]
    def substitutions: Option[Map[__string, List[__string]]]
    def titleOverride: Option[__string]
    def getBodyOverride: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bodyOverride", bodyOverride)
    def getChannelType: ZIO[Any, AwsError, zio.aws.pinpoint.model.ChannelType] =
      AwsError.unwrapOptionField("channelType", channelType)
    def getContext: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("context", context)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTitleOverride: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("titleOverride", titleOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
  ) extends zio.aws.pinpoint.model.AddressConfiguration.ReadOnly {
    override val bodyOverride: Option[__string] = scala
      .Option(impl.bodyOverride())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val channelType: Option[zio.aws.pinpoint.model.ChannelType] = scala
      .Option(impl.channelType())
      .map(value => zio.aws.pinpoint.model.ChannelType.wrap(value))
    override val context: Option[Map[__string, __string]] = scala
      .Option(impl.context())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val rawContent: Option[__string] = scala
      .Option(impl.rawContent())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val titleOverride: Option[__string] = scala
      .Option(impl.titleOverride())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.AddressConfiguration
  ): zio.aws.pinpoint.model.AddressConfiguration.ReadOnly = new Wrapper(impl)
}
