package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ApplicationDateRangeKpiResponse(
    applicationId: __string,
    endTime: __timestampIso8601,
    kpiName: __string,
    kpiResult: zio.aws.pinpoint.model.BaseKpiResult,
    nextToken: Option[__string] = None,
    startTime: __timestampIso8601
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ApplicationDateRangeKpiResponse = {
    import ApplicationDateRangeKpiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ApplicationDateRangeKpiResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .endTime(__timestampIso8601.unwrap(endTime): Instant)
      .kpiName(__string.unwrap(kpiName): java.lang.String)
      .kpiResult(kpiResult.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .startTime(__timestampIso8601.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.ApplicationDateRangeKpiResponse.ReadOnly =
    zio.aws.pinpoint.model.ApplicationDateRangeKpiResponse.wrap(buildAwsValue())
}
object ApplicationDateRangeKpiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ApplicationDateRangeKpiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ApplicationDateRangeKpiResponse =
      zio.aws.pinpoint.model.ApplicationDateRangeKpiResponse(
        applicationId,
        endTime,
        kpiName,
        kpiResult.asEditable,
        nextToken.map(value => value),
        startTime
      )
    def applicationId: __string
    def endTime: __timestampIso8601
    def kpiName: __string
    def kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly
    def nextToken: Option[__string]
    def startTime: __timestampIso8601
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEndTime: ZIO[Any, Nothing, __timestampIso8601] = ZIO.succeed(endTime)
    def getKpiName: ZIO[Any, Nothing, __string] = ZIO.succeed(kpiName)
    def getKpiResult
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.BaseKpiResult.ReadOnly] =
      ZIO.succeed(kpiResult)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationDateRangeKpiResponse
  ) extends zio.aws.pinpoint.model.ApplicationDateRangeKpiResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val endTime: __timestampIso8601 =
      zio.aws.pinpoint.model.primitives.__timestampIso8601(impl.endTime())
    override val kpiName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.kpiName())
    override val kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly =
      zio.aws.pinpoint.model.BaseKpiResult.wrap(impl.kpiResult())
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val startTime: __timestampIso8601 =
      zio.aws.pinpoint.model.primitives.__timestampIso8601(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationDateRangeKpiResponse
  ): zio.aws.pinpoint.model.ApplicationDateRangeKpiResponse.ReadOnly =
    new Wrapper(impl)
}
