package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApplicationResponse(
    arn: __string,
    id: __string,
    name: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ApplicationResponse = {
    import ApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
      .builder()
      .arn(__string.unwrap(arn): java.lang.String)
      .id(__string.unwrap(id): java.lang.String)
      .name(__string.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ApplicationResponse.ReadOnly =
    zio.aws.pinpoint.model.ApplicationResponse.wrap(buildAwsValue())
}
object ApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ApplicationResponse =
      zio.aws.pinpoint.model.ApplicationResponse(
        arn,
        id,
        name,
        tags.map(value => value)
      )
    def arn: __string
    def id: __string
    def name: __string
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
  ) extends zio.aws.pinpoint.model.ApplicationResponse.ReadOnly {
    override val arn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.arn())
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val name: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.name())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
  ): zio.aws.pinpoint.model.ApplicationResponse.ReadOnly = new Wrapper(impl)
}
